/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.chapterIV.builders;

import java.io.StringWriter;
import java.util.Properties;

import javax.xml.bind.JAXB;

import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import be.ehealth.businessconnector.chapterIV.domain.ChapterIVReferences;
import be.ehealth.businessconnector.chapterIV.exception.ChapterIVBusinessConnectorException;
import be.ehealth.businessconnector.chapterIV.exception.ChapterIVBusinessConnectorExceptionValues;
import be.ehealth.businessconnector.chapterIV.testutil.TestUtils;
import be.ehealth.businessconnector.chapterIV.utils.FolderTypeUtils;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.MarshallerHelper;
import be.fgov.ehealth.chap4.protocol.v1.AskChap4MedicalAdvisorAgreementRequest;
import be.fgov.ehealth.standards.kmehr.id.v1.IDPATIENT;
import be.fgov.ehealth.standards.kmehr.schema.v1.FolderType;
import be.fgov.ehealth.technicalconnector.tests.utils.TestPropertiesLoader;
import be.fgov.ehealth.technicalconnector.tests.utils.XmlAsserter;


/**
 * Unit testing the ConsultationBuilder
 * 
 * @author EHP
 * @param <Kmehrmessage>
 * 
 */
@Ignore("these test use files created with outdated and invalid certificates and are tested in the integration tests")
// TODO TDJIR EHCON-1143: create maintainable test or remove these tests
public class AdmissionBuilderTest extends AbstractBuilderTest {


    private static final Logger LOG = LoggerFactory.getLogger(AdmissionBuilderTest.class);

    private static Properties props = null;

    @BeforeClass
    public static void init() throws Exception {
        props = TestPropertiesLoader.getProperties("/be.ehealth.businessconnector.chapterIV.test.properties");
        Assume.assumeFalse("orgpharmacy".equals(props.getProperty("session.professionType")));
    }


    /**
     * Test with an invalid kmehrmessageType
     * 
     * @throws Exception
     */
    @Test(expected = ChapterIVBusinessConnectorException.class)
    public final void testInvalidRequest() throws Exception {

        AdmissionBuilder builder = getFactory().getAdmissionBuilder();
        FolderType folder = null;
        boolean isTest = true;
        ChapterIVReferences references = new ChapterIVReferences("33");
        references.setCommonNIPReference("44");


        builder.buildRequest(folder, isTest, references, FolderTypeUtils.retrieveConsultationStartDateOrAgreementStartDate(folder));
    }

    /**
     * Test with a valid kmehrmessageType and with a ssin.
     * 
     * @throws Exception
     */
    @Test
    public final void testRequestWithoutSsin() throws Exception {

        AdmissionBuilder builder = getFactory().getAdmissionBuilder();

        MarshallerHelper<FolderType, FolderType> helper = new MarshallerHelper<FolderType, FolderType>(FolderType.class, FolderType.class);
        FolderType folder = helper.toObject(ConnectorIOUtils.getResourceAsStream("/examples/sample-chapter4-consultation-request-without-ssin.xml"));
        boolean isTest = true;

        ChapterIVReferences references = new ChapterIVReferences("33");
        references.setCommonNIPReference("44");


        AskChap4MedicalAdvisorAgreementRequest request = builder.buildRequest(folder, isTest, references, FolderTypeUtils.retrieveConsultationStartDateOrAgreementStartDate(folder));
        StringWriter sw = new StringWriter();
        JAXB.marshal(request, sw);
        LOG.debug(sw.toString());

        Assert.assertNotNull(request.getRecordCommonInput().getInputReference().toString());
        Assert.assertEquals(references.getCommonReference(), request.getCommonInput().getInputReference().toString());
        Assert.assertNull("nip reference should not be filled out by careProvider", request.getCommonInput().getNIPReference());
        Assert.assertEquals(props.getProperty("test.hcp.inss"), request.getCommonInput().getOrigin().getCareProvider().getPhysicalPerson().getSsin().getValue());
        Assert.assertEquals(props.getProperty("test.hcp.nihii"), request.getCommonInput().getOrigin().getCareProvider().getNihii().getValue().getValue());
        if (request.getCareReceiver().getSsin() != null) {
            Assert.assertNotNull(request.getCareReceiver().getRegNrWithMut());
        } else {
            Assert.assertNull(request.getCareReceiver().getSsin());
        }
        XmlAsserter.assertSimilar(TestUtils.getFileContents("/expected/builders/resultAdmissionRequestWithoutSsin.xml"), sw.toString());
    }

    /**
     * Test with a valid kmehrmessageType and without a SSIN
     * 
     * @throws Exception
     */
    @Test
    public final void testRequestWithSsin() throws Exception {

        AdmissionBuilder builder = getFactory().getAdmissionBuilder();


        MarshallerHelper<FolderType, FolderType> helper = new MarshallerHelper<FolderType, FolderType>(FolderType.class, FolderType.class);
        FolderType folder = helper.toObject(ConnectorIOUtils.getResourceAsStream("/examples/sample-chapter4-consultation-request-with-ssin.oa500.xml"));
        for (IDPATIENT idPatient : folder.getPatient().getIds()) {
            idPatient.setValue("79031425139");
        }
        boolean isTest = true;

        ChapterIVReferences references = new ChapterIVReferences("33");
        references.setCommonNIPReference("44");


        AskChap4MedicalAdvisorAgreementRequest request = builder.buildRequest(folder, isTest, references, FolderTypeUtils.retrieveConsultationStartDateOrAgreementStartDate(folder));


        StringWriter sw = new StringWriter();
        JAXB.marshal(request, sw);
        LOG.debug(sw.toString());

        Assert.assertNotNull(request.getRecordCommonInput().getInputReference().toString());
        Assert.assertEquals(references.getCommonReference(), request.getCommonInput().getInputReference().toString());
        Assert.assertNull("nip reference should not be filled out by careProvider", request.getCommonInput().getNIPReference());
        Assert.assertEquals(props.getProperty("test.hcp.inss"), request.getCommonInput().getOrigin().getCareProvider().getPhysicalPerson().getSsin().getValue());
        Assert.assertEquals(props.getProperty("test.hcp.nihii"), request.getCommonInput().getOrigin().getCareProvider().getNihii().getValue().getValue());
        XmlAsserter.assertSimilar(TestUtils.getFileContents("/expected/builders/resultAdmissionRequestWithSsin.xml"), sw.toString());

    }

    /**
     * Test with a valid kmehrmessageType but agreementStartDate null.
     * 
     * @throws Exception
     */
    @Test
    public final void testRequestWithoutAgreementStartDate() throws Exception {
        try {
            AdmissionBuilder builder = getFactory().getAdmissionBuilder();


            MarshallerHelper<FolderType, FolderType> helper = new MarshallerHelper<FolderType, FolderType>(FolderType.class, FolderType.class);
            FolderType folder = helper.toObject(ConnectorIOUtils.getResourceAsStream("/examples/sample-chapter4-admission-request-without-agreementstartdate.xml"));
            boolean isTest = true;

            ChapterIVReferences references = new ChapterIVReferences("33");
            references.setCommonNIPReference("44");

            builder.buildRequest(folder, isTest, references, null);

        } catch (ChapterIVBusinessConnectorException e) {
            Assert.assertEquals(ChapterIVBusinessConnectorExceptionValues.INPUT_PARAM_NULL.getErrorCode(), e.getErrorCode());
            Assert.assertEquals("Input parameter null : input parameter agreementStartDate was null", e.getMessage());
        }


    }


}
