/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.ehboxV2.session.impl;

import be.ehealth.businessconnector.ehbox.api.domain.exception.EhboxBusinessConnectorException;
import be.ehealth.businessconnector.ehboxV2.service.ConsultationService;
import be.ehealth.businessconnector.ehboxV2.service.PublicationService;
import be.ehealth.businessconnector.ehboxV2.service.impl.ConsultationServiceImpl;
import be.ehealth.businessconnector.ehboxV2.service.impl.PublicationServiceImpl;
import be.ehealth.businessconnector.ehboxV2.session.EhealthBoxServiceV2;
import be.ehealth.businessconnector.ehboxV2.validator.EhboxReplyValidator;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleBootstrap;
import be.ehealth.technicalconnector.exception.SessionManagementException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.utils.impl.JaxbContextFactory;
import be.ehealth.technicalconnector.validator.SessionValidator;
import be.fgov.ehealth.commons.protocol.v1.ResponseType;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.DeleteMessageRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.DeleteMessageResponse;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.GetBoxInfoRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.GetBoxInfoResponse;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.GetFullMessageResponse;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.GetHistoryResponse;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.GetMessageAcknowledgmentsStatusRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.GetMessageAcknowledgmentsStatusResponse;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.GetMessageListResponseType;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.GetMessagesListRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.MessageRequestType;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.MoveMessageRequest;
import be.fgov.ehealth.ehbox.publication.protocol.v2.SendMessageRequest;
import be.fgov.ehealth.ehbox.publication.protocol.v2.SendMessageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhealthBoxServiceV2Impl
implements EhealthBoxServiceV2,
ConfigurationModuleBootstrap.ModuleBootstrapHook {
    private static final Logger LOG = LoggerFactory.getLogger(EhealthBoxServiceV2Impl.class);
    private ConsultationService consultationService;
    private PublicationService publicationService;
    private SessionValidator sessionValidator;

    public EhealthBoxServiceV2Impl(SessionValidator sessionValidator, EhboxReplyValidator replyValidator) throws TechnicalConnectorException, EhboxBusinessConnectorException {
        this.consultationService = new ConsultationServiceImpl(sessionValidator, replyValidator);
        this.publicationService = new PublicationServiceImpl(sessionValidator, replyValidator);
        this.sessionValidator = sessionValidator;
    }

    public EhealthBoxServiceV2Impl() {
        LOG.debug("creating EhealthBoxServiceV2Impl for bootstrapping purposes");
    }

    @Override
    public SendMessageResponse sendMessage(SendMessageRequest sendMessageRequest) throws TechnicalConnectorException, EhboxBusinessConnectorException, SessionManagementException {
        SAMLToken token = Session.getInstance().getSession().getSAMLToken();
        SendMessageResponse response = this.publicationService.sendMessage(token, sendMessageRequest);
        return response;
    }

    @Override
    public GetBoxInfoResponse getBoxInfo(GetBoxInfoRequest getBoxInfoRequest) throws TechnicalConnectorException, EhboxBusinessConnectorException, SessionManagementException {
        this.sessionValidator.validateSession();
        SAMLToken token = Session.getInstance().getSession().getSAMLToken();
        GetBoxInfoResponse response = this.consultationService.getBoxInfo(token, getBoxInfoRequest);
        return response;
    }

    @Override
    public GetMessageListResponseType getMessageList(GetMessagesListRequest request) throws TechnicalConnectorException, EhboxBusinessConnectorException, SessionManagementException {
        this.sessionValidator.validateSession();
        SAMLToken token = Session.getInstance().getSession().getSAMLToken();
        GetMessageListResponseType response = this.consultationService.getMessageList(token, request);
        return response;
    }

    @Override
    public GetFullMessageResponse getFullMessage(MessageRequestType request) throws TechnicalConnectorException, EhboxBusinessConnectorException, SessionManagementException {
        this.sessionValidator.validateSession();
        SAMLToken token = Session.getInstance().getSession().getSAMLToken();
        GetFullMessageResponse response = this.consultationService.getFullMessage(token, request);
        return response;
    }

    @Override
    public ResponseType moveMessage(MoveMessageRequest request) throws TechnicalConnectorException, EhboxBusinessConnectorException, SessionManagementException {
        this.sessionValidator.validateSession();
        SAMLToken token = Session.getInstance().getSession().getSAMLToken();
        ResponseType response = this.consultationService.moveMessage(token, request);
        return response;
    }

    @Override
    public GetHistoryResponse getMessageHistory(MessageRequestType request) throws TechnicalConnectorException, EhboxBusinessConnectorException, SessionManagementException {
        this.sessionValidator.validateSession();
        SAMLToken token = Session.getInstance().getSession().getSAMLToken();
        GetHistoryResponse response = this.consultationService.getMessageHistory(token, request);
        return response;
    }

    @Override
    public GetMessageAcknowledgmentsStatusResponse getMessageAcknowledgmentsStatusRequest(GetMessageAcknowledgmentsStatusRequest request) throws TechnicalConnectorException, EhboxBusinessConnectorException, SessionManagementException {
        this.sessionValidator.validateSession();
        SAMLToken token = Session.getInstance().getSession().getSAMLToken();
        GetMessageAcknowledgmentsStatusResponse response = this.consultationService.getMessageAcknowledgmentsStatusResponse(token, request);
        return response;
    }

    @Override
    public DeleteMessageResponse deleteMessage(DeleteMessageRequest request) throws TechnicalConnectorException, EhboxBusinessConnectorException {
        this.sessionValidator.validateSession();
        SAMLToken token = Session.getInstance().getSession().getSAMLToken();
        DeleteMessageResponse response = this.consultationService.deleteMessage(token, request);
        return response;
    }

    public void bootstrap() {
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{DeleteMessageRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{DeleteMessageResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetBoxInfoRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetBoxInfoResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetFullMessageResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetHistoryResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetMessageAcknowledgmentsStatusRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetMessageAcknowledgmentsStatusResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetMessageListResponseType.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetMessagesListRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{MessageRequestType.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{MoveMessageRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{SendMessageRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{SendMessageResponse.class});
    }
}

