/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.ehboxV2.builders.impl;

import be.ehealth.businessconnector.ehbox.api.domain.Addressee;
import be.ehealth.businessconnector.ehbox.api.domain.Document;
import be.ehealth.businessconnector.ehbox.api.domain.DocumentMessage;
import be.ehealth.businessconnector.ehbox.api.domain.Message;
import be.ehealth.businessconnector.ehbox.api.domain.NewsMessage;
import be.ehealth.businessconnector.ehbox.api.domain.exception.EhboxBusinessConnectorException;
import be.ehealth.businessconnector.ehbox.api.utils.SigningValue;
import be.ehealth.businessconnector.ehboxV2.builders.SendMessageBuilder;
import be.ehealth.technicalconnector.enumeration.Charset;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.service.etee.Crypto;
import be.ehealth.technicalconnector.service.etee.domain.EncryptionToken;
import be.ehealth.technicalconnector.service.keydepot.KeyDepotManager;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.utils.ByteArrayDatasource;
import be.ehealth.technicalconnector.utils.SessionUtil;
import be.fgov.ehealth.ehbox.core.v2.AnnexType;
import be.fgov.ehealth.ehbox.core.v2.BoxIdType;
import be.fgov.ehealth.ehbox.core.v2.ContentSpecificationType;
import be.fgov.ehealth.ehbox.core.v2.ContentType;
import be.fgov.ehealth.ehbox.core.v2.CustomMetaType;
import be.fgov.ehealth.ehbox.core.v2.DocumentType;
import be.fgov.ehealth.ehbox.core.v2.FreeInformationsType;
import be.fgov.ehealth.ehbox.core.v2.MandateType;
import be.fgov.ehealth.ehbox.core.v2.NewsType;
import be.fgov.ehealth.ehbox.core.v2.SigningType;
import be.fgov.ehealth.ehbox.publication.protocol.v2.ContentContext;
import be.fgov.ehealth.ehbox.publication.protocol.v2.DestinationContext;
import be.fgov.ehealth.ehbox.publication.protocol.v2.SendMessageRequest;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.bouncycastle.cms.CMSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMessageBuilderImpl
implements SendMessageBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(SendMessageBuilderImpl.class);
    private KeyDepotManager keydepotManager;

    @Deprecated
    public SendMessageBuilderImpl(Crypto encryptionCrypto, KeyDepotManager keydepotManager) {
        this(keydepotManager);
    }

    public SendMessageBuilderImpl(KeyDepotManager keydepotManager) {
        this.keydepotManager = keydepotManager;
    }

    @Override
    public SendMessageRequest buildMessage(DocumentMessage<be.fgov.ehealth.ehbox.consultation.protocol.v2.Message> document) throws IOException, EhboxBusinessConnectorException, TechnicalConnectorException, CMSException {
        SendMessageRequest sendMessageRequest = new SendMessageRequest();
        sendMessageRequest.setPublicationId(document.getPublicationId());
        if (document.getSender() != null) {
            sendMessageRequest.setBoxId(new BoxIdType());
            sendMessageRequest.getBoxId().setId(document.getSender().getId());
            sendMessageRequest.getBoxId().setQuality(document.getSender().getQuality());
            sendMessageRequest.getBoxId().setSubType(document.getSender().getSubType());
            sendMessageRequest.getBoxId().setType(document.getSender().getType());
        }
        this.buildMandator((Message<?>)document, sendMessageRequest);
        HashSet<EncryptionToken> destinationEtkSet = new HashSet<EncryptionToken>();
        this.processAddressees(document, sendMessageRequest, destinationEtkSet);
        ContentContext content = new ContentContext();
        ContentSpecificationType contentSpecification = new ContentSpecificationType();
        contentSpecification.setIsEncrypted(document.isEncrypted());
        contentSpecification.setIsImportant(document.isImportant());
        content.setContentSpecification(contentSpecification);
        this.processCustomMetas(document, content);
        ContentType contentType = new ContentType();
        DocumentType documentType = new DocumentType();
        documentType.setTitle(document.getDocumentTitle());
        if (document.getDocument() != null) {
            documentType.setDownloadFileName(document.getDocument().getFilename());
            documentType.setMimeType(document.getDocument().getMimeType());
            DataHandler binarycontent = this.encodeDataHandler(document.getDocument().getContent(), document.isEncrypted(), destinationEtkSet);
            documentType.setEncryptableBinaryContent(binarycontent);
        }
        contentType.setDocument(documentType);
        if (document.getFreeText() != null && document.getFreeText().getBytes(Charset.UTF_8.getName()) != null) {
            FreeInformationsType freeText = new FreeInformationsType();
            freeText.setEncryptableFreeText(this.encodeByteArray(document.getFreeText().getBytes(Charset.UTF_8.getName()), document.isEncrypted(), destinationEtkSet));
            contentType.setFreeInformations(freeText);
        }
        if (document.getPatientInss() != null) {
            contentType.setEncryptableINSSPatient(this.encodeDataHandler(document.getPatientInss().getBytes(Charset.UTF_8.getName()), document.isEncrypted(), destinationEtkSet));
        }
        this.processAnnexes(document, destinationEtkSet, contentType);
        content.setContent(contentType);
        if (document.getDocument() != null && document.getDocument().getSigning() != null) {
            documentType.setSigning(this.processSigning(document.getDocument().getSigning()));
        }
        sendMessageRequest.setContentContext(content);
        return sendMessageRequest;
    }

    private void processAnnexes(DocumentMessage<be.fgov.ehealth.ehbox.consultation.protocol.v2.Message> document, Set<EncryptionToken> destinationEtkSet, ContentType contentType) throws IOException, TechnicalConnectorException {
        for (Document annex : document.getAnnexList()) {
            AnnexType annexType = new AnnexType();
            annexType.setDownloadFileName(annex.getFilename());
            annexType.setEncryptableBinaryContent(this.encodeDataHandler(annex.getContent(), document.isEncrypted(), destinationEtkSet));
            annexType.setEncryptableTitle(this.encodeDataHandler(annex.getTitle().getBytes(Charset.UTF_8.getName()), document.isEncrypted(), destinationEtkSet));
            annexType.setMimeType(annex.getMimeType());
            annexType.setSigning(this.processSigning(document.getDocument().getSigning()));
            contentType.getAnnices().add(annexType);
        }
    }

    private void processCustomMetas(DocumentMessage<be.fgov.ehealth.ehbox.consultation.protocol.v2.Message> document, ContentContext content) {
        if (document.getCustomMetas().keySet().size() > 0) {
            Set keySet = document.getCustomMetas().keySet();
            for (String key : keySet) {
                String value = (String)document.getCustomMetas().get(key);
                CustomMetaType meta = new CustomMetaType();
                meta.setKey(key);
                meta.setValue(value);
                content.getCustomMetas().add(meta);
            }
        }
    }

    private void processAddressees(DocumentMessage<be.fgov.ehealth.ehbox.consultation.protocol.v2.Message> document, SendMessageRequest sendMessageRequest, Set<EncryptionToken> destinationEtkSet) throws TechnicalConnectorException, EhboxBusinessConnectorException {
        for (Addressee addressee : document.getDestinations()) {
            DestinationContext destination = this.buildDestination(addressee);
            sendMessageRequest.getDestinationContexts().add(destination);
            if (!document.isEncrypted()) continue;
            destinationEtkSet.addAll(this.getETKForAddressee(addressee));
            destinationEtkSet.add(this.keydepotManager.getEncryptionETK());
        }
    }

    private Set<EncryptionToken> getETKForAddressee(Addressee addressee) throws TechnicalConnectorException, EhboxBusinessConnectorException {
        if (SessionUtil.getEncryptionCrypto() != null || Session.getInstance().getSession().getEncryptionCredential() != null) {
            return this.keydepotManager.getEtkSet(addressee.getIdentifierTypeHelper(), Long.valueOf(addressee.getIdAsLong()), addressee.getApplicationId());
        }
        LOG.debug("\t## " + TechnicalConnectorExceptionValues.NO_ENCRYPTIONKEYS.getMessage());
        throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.NO_ENCRYPTIONKEYS, new Object[0]);
    }

    private void buildMandator(Message<?> document, SendMessageRequest sendMessageRequest) {
        MandateType mandator = new MandateType();
        if (document.getMandatee() != null) {
            mandator.setId(document.getMandatee().getId());
            mandator.setQuality(document.getMandatee().getQuality());
            mandator.setSubType(document.getMandatee().getSubType());
            mandator.setType(document.getMandatee().getType());
            sendMessageRequest.setMandator(mandator);
        }
    }

    @Override
    public SendMessageRequest buildMessage(NewsMessage<be.fgov.ehealth.ehbox.consultation.protocol.v2.Message> document) throws IOException, EhboxBusinessConnectorException, TechnicalConnectorException {
        SendMessageRequest sendMessageRequest = new SendMessageRequest();
        sendMessageRequest.setPublicationId(document.getPublicationId());
        if (document.getSender() != null) {
            sendMessageRequest.setBoxId(new BoxIdType());
            sendMessageRequest.getBoxId().setId(document.getSender().getId());
            sendMessageRequest.getBoxId().setQuality(document.getSender().getQuality());
            sendMessageRequest.getBoxId().setSubType(document.getSender().getSubType());
            sendMessageRequest.getBoxId().setType(document.getSender().getType());
        }
        this.buildMandator((Message<?>)document, sendMessageRequest);
        HashSet<EncryptionToken> destinationEtkSet = new HashSet<EncryptionToken>();
        for (Addressee addressee : document.getDestinations()) {
            DestinationContext destination = this.buildDestination(addressee);
            sendMessageRequest.getDestinationContexts().add(destination);
            if (!document.isEncrypted()) continue;
            destinationEtkSet.addAll(this.getETKForAddressee(addressee));
            destinationEtkSet.add(this.keydepotManager.getEncryptionETK());
        }
        ContentContext content = new ContentContext();
        ContentSpecificationType contentSpecification = new ContentSpecificationType();
        contentSpecification.setIsEncrypted(document.isEncrypted());
        contentSpecification.setIsImportant(document.isImportant());
        content.setContentSpecification(contentSpecification);
        if (document.getCustomMetas().keySet().size() > 0) {
            Set keySet = document.getCustomMetas().keySet();
            for (String key : keySet) {
                String value = (String)document.getCustomMetas().get(key);
                CustomMetaType meta = new CustomMetaType();
                meta.setKey(key);
                meta.setValue(value);
                content.getCustomMetas().add(meta);
            }
        }
        ContentType contentType = new ContentType();
        NewsType newsType = new NewsType();
        Document documentContent = document.getDocument();
        if (documentContent != null) {
            newsType.setTitle(documentContent.getTitle());
            newsType.setMimeType(documentContent.getMimeType());
            DataHandler binarycontent = this.encodeDataHandler(documentContent.getContent(), document.isEncrypted(), destinationEtkSet);
            newsType.setEncryptableBinaryContent(binarycontent);
        }
        contentType.setNews(newsType);
        content.setContent(contentType);
        sendMessageRequest.setContentContext(content);
        return sendMessageRequest;
    }

    private DestinationContext buildDestination(Addressee addressee) {
        DestinationContext destination = new DestinationContext();
        destination.setId(addressee.getId());
        destination.setQuality(addressee.getQuality());
        destination.setType(addressee.getType());
        destination.setSubType(addressee.getSubType());
        return destination;
    }

    private DataHandler encodeDataHandler(byte[] content, boolean encrypted, Set<EncryptionToken> tokens) throws IOException, TechnicalConnectorException {
        byte[] byteVal = null;
        byteVal = encrypted ? SessionUtil.getEncryptionCrypto().seal(tokens, content) : content;
        ByteArrayDatasource dataSource = new ByteArrayDatasource(byteVal);
        return new DataHandler((DataSource)dataSource);
    }

    private byte[] encodeByteArray(byte[] content, boolean encrypted, Set<EncryptionToken> tokens) throws IOException, TechnicalConnectorException, EhboxBusinessConnectorException {
        byte[] byteVal = null;
        byteVal = encrypted && content != null && content.length != 0 ? SessionUtil.getEncryptionCrypto().seal(tokens, content) : content;
        return byteVal;
    }

    private SigningType processSigning(SigningValue value) {
        if (value != null) {
            SigningType result = new SigningType();
            result.setBinarySigningContent(value.getBinarySigningContent());
            result.setSigningDownloadFileName(value.getSigningDownloadFileName());
            result.setSigningType(value.getSigningType());
            result.setTextSigningContent(value.getTextSigningContent());
            return result;
        }
        return null;
    }
}

