/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.recipe.validators.impl;

import be.ehealth.businessconnector.recipe.exception.RecipeBusinessConnectorException;
import be.ehealth.businessconnector.recipe.exception.RecipeBusinessConnectorExceptionValues;
import be.ehealth.businessconnector.recipe.validators.KmehrValidator;
import be.ehealth.technicalconnector.handler.ErrorCollectorHandler;
import be.ehealth.technicalconnector.handler.SchemaValidatorHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

@Deprecated
public class KmehrValidatorImpl
implements KmehrValidator {
    private static final String RECIPE_SETTINGS = "/be.fgov.ehealth.business.recipe.properties";
    public static final String W3C_XML_SCHEMA_NS_URI = "http://www.w3.org/2001/XMLSchema";
    private static final Logger LOG = LoggerFactory.getLogger(KmehrValidatorImpl.class);
    static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    protected static final String[] RECIPE_ARRAY_NOTIFICATION = new String[]{"/XSD/recipe_v1/notification.xsd"};
    protected static final String[] RECIPE_ARRAY_FEEDBACK = new String[]{"/XSD/recipe_v1/feedback.xsd"};
    protected static final String[] RECIPE_ARRAY_KMEHRELEM = new String[]{"/XSD/kmehr/kmehr_elements-1_5.xsd"};
    private Properties recipeProps = new Properties();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KmehrValidatorImpl() throws RecipeBusinessConnectorException {
        InputStream resourceAsStream = null;
        try {
            resourceAsStream = KmehrValidatorImpl.class.getResourceAsStream(RECIPE_SETTINGS);
            if (resourceAsStream == null) {
                throw new RecipeBusinessConnectorException(RecipeBusinessConnectorExceptionValues.SETTINGS_NOT_FOUND, new Object[0]);
            }
            this.recipeProps.load(resourceAsStream);
            if (resourceAsStream == null) return;
        }
        catch (IOException e) {
            try {
                throw new RecipeBusinessConnectorException(RecipeBusinessConnectorExceptionValues.SETTINGS_NOT_FOUND, e, "Could not find the recipe settings file");
            }
            catch (Throwable throwable) {
                if (resourceAsStream == null) throw throwable;
                try {
                    resourceAsStream.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new RecipeBusinessConnectorException(RecipeBusinessConnectorExceptionValues.SETTINGS_NOT_FOUND, e2, "Could not close the stream to the recipe settings file");
                }
            }
        }
        try {
            resourceAsStream.close();
            return;
        }
        catch (IOException e) {
            throw new RecipeBusinessConnectorException(RecipeBusinessConnectorExceptionValues.SETTINGS_NOT_FOUND, e, "Could not close the stream to the recipe settings file");
        }
    }

    @Override
    public final boolean validateNotification(byte[] xmlDocument) throws RecipeBusinessConnectorException {
        this.xsdValidate(xmlDocument, RECIPE_ARRAY_NOTIFICATION);
        return true;
    }

    public final void assertValidFeedback(byte[] xmlDocument) throws RecipeBusinessConnectorException {
        this.xsdValidate(xmlDocument, RECIPE_ARRAY_FEEDBACK);
    }

    @Override
    public final boolean validateKmehrPrescription(byte[] xmlDocument, String prescriptionType) throws RecipeBusinessConnectorException {
        this.xsdValidate(xmlDocument, RECIPE_ARRAY_KMEHRELEM);
        return true;
    }

    private void xsdValidate(byte[] xmlDocument, String[] schemaFiles) throws RecipeBusinessConnectorException {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance(W3C_XML_SCHEMA_NS_URI);
            Object[] sources = new Source[]{};
            for (int i = 0; i < schemaFiles.length; ++i) {
                InputStream in = SchemaValidatorHandler.class.getResourceAsStream(schemaFiles[i]);
                if (in != null) {
                    StreamSource source = new StreamSource(in);
                    sources = (Source[])ArrayUtils.add((Object[])sources, (Object)source);
                    continue;
                }
                LOG.warn(schemaFiles[i] + " could not be retrieved");
            }
            Schema schema = null;
            schema = sources.length == 1 ? schemaFactory.newSchema(SchemaValidatorHandler.class.getResource(schemaFiles[0])) : schemaFactory.newSchema((Source[])sources);
            Validator validator = schema.newValidator();
            ErrorCollectorHandler collector = new ErrorCollectorHandler();
            validator.setErrorHandler((ErrorHandler)collector);
            validator.validate(new StreamSource(new ByteArrayInputStream(xmlDocument)));
            for (String warning : collector.getExceptionList(new String[]{"WARN"})) {
                LOG.warn(warning);
            }
            for (String error : collector.getExceptionList(new String[]{"ERROR", "FATAL"})) {
                LOG.error(error);
            }
            if (collector.hasExceptions(new String[]{"ERROR", "FATAL"})) {
                throw new RecipeBusinessConnectorException(RecipeBusinessConnectorExceptionValues.ERROR_XML_INVALID, "");
            }
        }
        catch (SAXException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new RecipeBusinessConnectorException(RecipeBusinessConnectorExceptionValues.ERROR_XML_INVALID, e, "");
        }
        catch (IOException e) {
            throw new RecipeBusinessConnectorException(RecipeBusinessConnectorExceptionValues.ERROR_XML_INVALID, e, "");
        }
    }
}

