/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.recipe.utils;

import be.ehealth.businessconnector.recipe.builders.BuilderFactory;
import be.ehealth.businessconnector.recipe.builders.RevokePrescriptionBuilder;
import be.ehealth.businessconnector.recipe.exception.RecipeBusinessConnectorException;
import be.ehealth.businessconnector.recipe.service.PrescriberService;
import be.ehealth.businessconnector.recipe.utils.ACLUtils;
import be.ehealth.technicalconnector.exception.SessionManagementException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.etee.domain.EncryptionToken;
import be.ehealth.technicalconnector.service.keydepot.KeyDepotManagerFactory;
import be.ehealth.technicalconnector.service.kgss.KgssManager;
import be.ehealth.technicalconnector.service.kgss.domain.KeyResult;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.utils.IdentifierType;
import be.ehealth.technicalconnector.utils.SessionUtil;
import be.fgov.ehealth.etee.kgss._1_0.protocol.CredentialType;
import be.fgov.ehealth.recipe.protocol.v1.CreatePrescriptionRequest;
import be.fgov.ehealth.recipe.protocol.v1.CreatePrescriptionResponse;
import be.fgov.ehealth.recipe.protocol.v1.GetPrescriptionForPrescriberRequest;
import be.fgov.ehealth.recipe.protocol.v1.GetPrescriptionForPrescriberResponse;
import be.fgov.ehealth.recipe.protocol.v1.ListFeedbacksRequest;
import be.fgov.ehealth.recipe.protocol.v1.ListFeedbacksResponse;
import be.fgov.ehealth.recipe.protocol.v1.ListOpenPrescriptionsRequest;
import be.fgov.ehealth.recipe.protocol.v1.ListOpenPrescriptionsResponse;
import be.fgov.ehealth.recipe.protocol.v1.RevokePrescriptionRequest;
import be.fgov.ehealth.recipe.protocol.v1.SendNotificationRequest;
import be.fgov.ehealth.recipe.protocol.v1.UpdateFeedbackFlagRequest;
import be.recipe.services.CreatePrescriptionResult;
import be.recipe.services.GetListOpenPrescriptionResult;
import be.recipe.services.GetPrescriptionForPrescriberResult;
import be.recipe.services.ListFeedbackItem;
import be.recipe.services.ListFeedbacksResult;
import java.util.List;

@Deprecated
public final class RecipeCommonsUtil {
    private RecipeCommonsUtil() {
    }

    public static void prepareCreatePrescription(long patientId, String prescriptionType) throws TechnicalConnectorException, SessionManagementException, RecipeBusinessConnectorException {
        Long nihii = Long.parseLong(SessionUtil.getNihii11());
        List<CredentialType> acl = ACLUtils.createACL(prescriptionType, nihii, null, patientId);
        byte[] systemETK = KeyDepotManagerFactory.getKeyDepotManager().getHolderOfKeyETK().getEtk().getEncoded();
        String cacheId = patientId + "#" + prescriptionType;
        KgssManager.getInstance().add(cacheId, acl, systemETK);
    }

    public static String createPrescription(BuilderFactory builders, PrescriberService service, boolean feedbackRequested, long patientId, byte[] prescription, String prescriptionType) throws RecipeBusinessConnectorException, TechnicalConnectorException {
        String cacheId = patientId + "#" + prescriptionType;
        if (!KgssManager.getInstance().containsKey(cacheId)) {
            RecipeCommonsUtil.prepareCreatePrescription(patientId, prescriptionType);
        }
        KeyResult key = KgssManager.getInstance().remove(cacheId);
        CreatePrescriptionRequest request = builders.getCreatePrescriptionBuilder().buildRequest(feedbackRequested, patientId, prescription, prescriptionType, key);
        CreatePrescriptionResponse response = service.createPrescription(Session.getInstance().getSession().getSAMLToken(), request);
        CreatePrescriptionResult result = builders.getCreatePrescriptionBuilder().buildResult(response);
        return result.getRid();
    }

    public static void sendNotification(BuilderFactory builders, PrescriberService service, byte[] notificationText, long patientId, long executorId) throws TechnicalConnectorException, SessionManagementException {
        EncryptionToken etkRecipient = KeyDepotManagerFactory.getKeyDepotManager().getEtk(IdentifierType.NIHII_PHARMACY, Long.valueOf(executorId), "");
        SendNotificationRequest request = builders.getSendNotificationBuilder().buildRequest(notificationText, patientId, executorId, etkRecipient);
        service.sendNotification(Session.getInstance().getSession().getSAMLToken(), request);
    }

    public static void revokePrescription(BuilderFactory builders, PrescriberService service, String rid, String reason) throws RecipeBusinessConnectorException, TechnicalConnectorException {
        RevokePrescriptionBuilder builder = builders.getRevokePrescriptionBuilder();
        RevokePrescriptionRequest request = builder.buildRevokePrescription(rid, reason);
        service.revokePrescription(Session.getInstance().getSession().getSAMLToken(), request);
    }

    public static GetPrescriptionForPrescriberResult getPrescription(BuilderFactory builders, PrescriberService service, String rid) throws TechnicalConnectorException, SessionManagementException {
        GetPrescriptionForPrescriberRequest request = builders.getGetPrescriptionBuilder().buildRequest(rid);
        GetPrescriptionForPrescriberResponse response = service.getPrescription(Session.getInstance().getSession().getSAMLToken(), request);
        GetPrescriptionForPrescriberResult result = builders.getGetPrescriptionBuilder().buildResult(response);
        return result;
    }

    public static List<String> listOpenPrescription(BuilderFactory builders, PrescriberService service) throws TechnicalConnectorException, SessionManagementException {
        ListOpenPrescriptionsRequest request = builders.getListOpenPrescriptionBuilder().buildRequest();
        ListOpenPrescriptionsResponse response = service.listOpenPrescription(Session.getInstance().getSession().getSAMLToken(), request);
        GetListOpenPrescriptionResult result = builders.getListOpenPrescriptionBuilder().buildResult(response);
        return result.getPrescriptions();
    }

    public static void updateFeedbackFlag(BuilderFactory builders, PrescriberService service, String rid, boolean feedbackAllowed) throws TechnicalConnectorException, SessionManagementException {
        UpdateFeedbackFlagRequest request = builders.getUpdateFeedbackFlagBuilder().buildRequest(rid, feedbackAllowed);
        service.updateFeedbackFlag(Session.getInstance().getSession().getSAMLToken(), request);
    }

    public static List<ListFeedbackItem> listFeedback(BuilderFactory builders, PrescriberService service, boolean readFlag) throws TechnicalConnectorException, SessionManagementException, RecipeBusinessConnectorException {
        ListFeedbacksRequest request = builders.getListFeedbackBuilder().buildRequest(readFlag);
        ListFeedbacksResponse response = service.listFeedbacks(Session.getInstance().getSession().getSAMLToken(), request);
        ListFeedbacksResult result = builders.getListFeedbackBuilder().buildResult(response);
        return result.getFeedbacks();
    }
}

