/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.recipe.utils;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.fgov.ehealth.etee.kgss._1_0.protocol.CredentialType;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class ACLUtils {
    private static final String PATIENT_ID = "%PATIENT_ID%";
    private static final String EXECUTOR_ID = "%EXECUTOR_ID%";
    private static final String PRESCRIBER_ID = "%PRESCRIBER_ID%";
    private static final Logger LOG = LoggerFactory.getLogger(ACLUtils.class);
    private static final String KGSS_CREATE_PRESCRIPTION_ACL = "kgss.createPrescription.ACL.";
    private static Properties props = new Properties();

    private ACLUtils() {
    }

    public static List<CredentialType> createACL(String prescriptionType, Long prescriberId, Long executorId, Long patientId) throws TechnicalConnectorException {
        ArrayList<CredentialType> allowedReaders = new ArrayList<CredentialType>();
        List<String> credentialTypes = ACLUtils.getMatchingProperties(KGSS_CREATE_PRESCRIPTION_ACL + prescriptionType);
        LOG.debug("#of ACL's found in config: " + credentialTypes.size());
        for (String credentialTypeStr : credentialTypes) {
            String[] atrs = credentialTypeStr.split(",");
            if (atrs.length != 3 && atrs.length != 2) {
                LOG.debug("\t## " + MessageFormat.format(TechnicalConnectorExceptionValues.INVALID_ATTRIBUTES_LENGTH.getMessage(), atrs.length + ""));
                throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.INVALID_ATTRIBUTES_LENGTH, new Object[]{atrs.length});
            }
            String value = "";
            if (atrs.length == 3) {
                value = atrs[2];
                value = value.replaceAll(PRESCRIBER_ID, ACLUtils.formatId(prescriberId, 11));
                value = value.replaceAll(EXECUTOR_ID, ACLUtils.formatId(executorId, 11));
                value = value.replaceAll(PATIENT_ID, ACLUtils.formatId(patientId, 11));
            }
            LOG.debug("\tACL: " + atrs[0] + " # " + atrs[1] + " # " + value);
            CredentialType ct = new CredentialType();
            ct.setNamespace(atrs[0]);
            ct.setName(atrs[1]);
            ct.getValues().add(value);
            allowedReaders.add(ct);
        }
        if (allowedReaders.isEmpty()) {
            LOG.warn("No a");
        }
        return allowedReaders;
    }

    private static List<String> getMatchingProperties(String rootKey) {
        int i = 1;
        ArrayList<String> ret = new ArrayList<String>();
        String key;
        while (props.getProperty(key = rootKey + "." + i) != null) {
            ret.add(props.getProperty(key));
            ++i;
        }
        return ret;
    }

    private static String formatId(Long id, int nDigits) {
        if (id == null) {
            return null;
        }
        return StringUtils.leftPad((String)Long.toString(id), (int)nDigits, (String)"0");
    }

    public static Properties getRecipeProps() {
        return props;
    }

    static {
        try {
            props.load(ACLUtils.class.getResourceAsStream("/be.fgov.ehealth.business.recipe.properties"));
        }
        catch (IOException e) {
            LOG.warn("Couldn't load recipe properties");
        }
    }
}

