/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.decrypt;

import be.fgov.ehealth.etee.crypto.decrypt.CMSMessageContext;
import be.fgov.ehealth.etee.crypto.decrypt.CMSReader;
import be.fgov.ehealth.etee.crypto.decrypt.CMSReaderException;
import be.fgov.ehealth.etee.crypto.status.CMSErrorType;
import be.fgov.ehealth.etee.crypto.utils.CertStringBuilder;
import be.fgov.ehealth.etee.crypto.utils.Iterables;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

abstract class CMSReaderAbstract<T>
implements CMSReader<T> {
    private static final Logger LOGGER = Logger.getLogger(CMSReaderAbstract.class);

    CMSReaderAbstract() {
    }

    @Override
    public void read(CMSMessageContext<T> msgContext) throws CMSReaderException {
        this.readSignerInformation(msgContext);
        this.readSignedContent(msgContext);
        this.readCertificates(msgContext);
        this.readAuthenticationCertificate(msgContext);
    }

    protected abstract void readCertificates(CMSMessageContext<T> var1) throws CMSReaderException;

    protected abstract void readSignerInformation(CMSMessageContext<T> var1) throws CMSReaderException;

    protected void readAuthenticationCertificate(CMSMessageContext<T> msgContext) throws CMSReaderException {
        if (msgContext.getAuthenticationCertificate() == null && msgContext.getCertificateStore() != null) {
            Collection certificates = msgContext.getCertificateStore().getMatches((Selector)msgContext.getSignerInformation().getSID());
            LOGGER.warn((Object)("Found #" + certificates.size() + " Signer Certificate(s) in SignerInfo."));
            if (certificates.size() == 1) {
                try {
                    X509CertificateHolder certificateHolder = (X509CertificateHolder)Iterables.first(certificates);
                    X509Certificate certificate = this.extractCertificate(certificateHolder);
                    LOGGER.info((Object)("Selected Signer Certificate from SignerInfo: " + CertStringBuilder.build(certificate)));
                    msgContext.setAuthenticationCertificate(certificate);
                }
                catch (CertificateException e) {
                    throw new CMSReaderException(CMSErrorType.INCORRECTLY_ENCODED_CERTIFICATES, e);
                }
            }
        }
    }

    protected List<X509Certificate> extractCertificateChain(Store store) throws CertificateException {
        Collection certificateChain = store.getMatches(null);
        List<X509Certificate> certificates = Iterables.newList();
        for (X509CertificateHolder certificateHolder : certificateChain) {
            certificates.add(this.extractCertificate(certificateHolder));
        }
        LOGGER.info((Object)("Found #" + certificates.size() + " certificates in store."));
        return certificates;
    }

    protected X509Certificate extractCertificate(X509CertificateHolder certificateHolder) throws CertificateException {
        return new JcaX509CertificateConverter().getCertificate(certificateHolder);
    }
}

