/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.civics.service.impl;

import be.ehealth.businessconnector.civics.exception.CivicsBusinessConnectorException;
import be.ehealth.businessconnector.civics.exception.CivicsBusinessConnectorExceptionValues;
import be.ehealth.businessconnector.civics.service.SamCivicsService;
import be.ehealth.businessconnector.civics.service.ServiceFactory;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleBootstrap;
import be.ehealth.technicalconnector.exception.SessionManagementException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.utils.ConnectorExceptionUtils;
import be.ehealth.technicalconnector.utils.impl.JaxbContextFactory;
import be.ehealth.technicalconnector.validator.SessionValidator;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.ehealth.technicalconnector.ws.domain.GenericResponse;
import be.fgov.ehealth.errors.soa.v1.BusinessError;
import be.fgov.ehealth.errors.soa.v1.SystemError;
import be.fgov.ehealth.samcivics.type.v1.FindCNKRequest;
import be.fgov.ehealth.samcivics.type.v1.FindCNKResponse;
import be.fgov.ehealth.samcivics.type.v1.FindParagraphTextRequest;
import be.fgov.ehealth.samcivics.type.v1.FindParagraphTextResponse;
import be.fgov.ehealth.samcivics.type.v1.FindReimbursementConditionsRequest;
import be.fgov.ehealth.samcivics.type.v1.FindReimbursementConditionsResponse;
import be.fgov.ehealth.samcivics.type.v1.GetAddedDocumentsRequest;
import be.fgov.ehealth.samcivics.type.v1.GetAddedDocumentsResponse;
import be.fgov.ehealth.samcivics.type.v1.GetParagraphExclusionsRequest;
import be.fgov.ehealth.samcivics.type.v1.GetParagraphExclusionsResponse;
import be.fgov.ehealth.samcivics.type.v1.GetParagraphIncludedSpecialitiesRequest;
import be.fgov.ehealth.samcivics.type.v1.GetParagraphIncludedSpecialitiesResponse;
import be.fgov.ehealth.samcivics.type.v1.GetProfessionalAuthorisationsRequest;
import be.fgov.ehealth.samcivics.type.v1.GetProfessionalAuthorisationsResponse;
import be.fgov.ehealth.samcivics.type.v1.ParagraphAndVersesRequestType;
import be.fgov.ehealth.samcivics.type.v1.ParagraphRequestType;
import java.net.MalformedURLException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import javax.xml.soap.SOAPException;
import javax.xml.ws.soap.SOAPFaultException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamCivicsServiceImpl
implements SamCivicsService,
ConfigurationModuleBootstrap.ModuleBootstrapHook {
    private static final Logger LOG = LoggerFactory.getLogger(SamCivicsServiceImpl.class);
    private SessionValidator sessionValidator;

    public SamCivicsServiceImpl(SessionValidator sessionValidator) {
        this.sessionValidator = sessionValidator;
    }

    public SamCivicsServiceImpl() {
        LOG.debug("creating SamCivicsServiceImpl for ModuleBootstrapHook");
    }

    private GenericRequest getService(X509Certificate certificate, PrivateKey privateKey) throws TechnicalConnectorException, CivicsBusinessConnectorException, SessionManagementException {
        try {
            this.sessionValidator.validateSession();
            return ServiceFactory.getSamCivicsPort(certificate, privateKey);
        }
        catch (MalformedURLException e) {
            CivicsBusinessConnectorExceptionValues errorValue = CivicsBusinessConnectorExceptionValues.MALFORMED_URL;
            String file = "SAM Civics file";
            LOG.debug("\t## " + MessageFormat.format(errorValue.getMessage(), file) + " : throwing civics business connector exception");
            throw new CivicsBusinessConnectorException(errorValue, e, file);
        }
    }

    @Override
    public FindParagraphTextResponse findParagraphText(X509Certificate certificate, PrivateKey privateKey, ParagraphAndVersesRequestType request) throws CivicsBusinessConnectorException, TechnicalConnectorException, SessionManagementException {
        try {
            GenericRequest service = this.getService(certificate, privateKey);
            FindParagraphTextRequest genRequest = new FindParagraphTextRequest();
            this.dozer(request, (ParagraphAndVersesRequestType)genRequest);
            service.setPayload((Object)genRequest);
            GenericResponse xmlResponse = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(service);
            return (FindParagraphTextResponse)xmlResponse.asObject(FindParagraphTextResponse.class);
        }
        catch (SOAPException e) {
            LOG.error(e.getMessage());
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, new Object[]{e.getMessage(), e});
        }
        catch (SOAPFaultException e) {
            ConnectorExceptionUtils.processSOAPFault((SOAPFaultException)e);
            return null;
        }
    }

    @Override
    public GetParagraphIncludedSpecialitiesResponse getParagraphIncludedSpecialties(X509Certificate certificate, PrivateKey privateKey, ParagraphRequestType request) throws CivicsBusinessConnectorException, TechnicalConnectorException, SessionManagementException {
        try {
            GenericRequest service = this.getService(certificate, privateKey);
            GetParagraphIncludedSpecialitiesRequest genRequest = new GetParagraphIncludedSpecialitiesRequest();
            this.dozer(request, (ParagraphRequestType)genRequest);
            service.setPayload((Object)genRequest);
            GenericResponse xmlResponse = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(service);
            return (GetParagraphIncludedSpecialitiesResponse)xmlResponse.asObject(GetParagraphIncludedSpecialitiesResponse.class);
        }
        catch (SOAPException e) {
            LOG.error(e.getMessage());
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, new Object[]{e.getMessage(), e});
        }
        catch (SOAPFaultException e) {
            ConnectorExceptionUtils.processSOAPFault((SOAPFaultException)e);
            return null;
        }
    }

    @Override
    public GetParagraphExclusionsResponse getParagraphExclusions(X509Certificate certificate, PrivateKey privateKey, ParagraphRequestType request) throws CivicsBusinessConnectorException, TechnicalConnectorException, SessionManagementException {
        try {
            GenericRequest service = this.getService(certificate, privateKey);
            GetParagraphExclusionsRequest genRequest = new GetParagraphExclusionsRequest();
            this.dozer(request, (ParagraphRequestType)genRequest);
            service.setPayload((Object)genRequest);
            GenericResponse xmlResponse = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(service);
            return (GetParagraphExclusionsResponse)xmlResponse.asObject(GetParagraphExclusionsResponse.class);
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, new Object[]{e.getMessage(), e});
        }
        catch (SOAPFaultException e) {
            ConnectorExceptionUtils.processSOAPFault((SOAPFaultException)e);
            return null;
        }
    }

    @Override
    public GetProfessionalAuthorisationsResponse getProfessionalAuthorizations(X509Certificate certificate, PrivateKey privateKey, GetProfessionalAuthorisationsRequest request) throws CivicsBusinessConnectorException, TechnicalConnectorException, SessionManagementException {
        try {
            GenericRequest service = this.getService(certificate, privateKey);
            service.setPayload((Object)request);
            GenericResponse xmlResponse = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(service);
            return (GetProfessionalAuthorisationsResponse)xmlResponse.asObject(GetProfessionalAuthorisationsResponse.class);
        }
        catch (SOAPException e) {
            LOG.error(e.getMessage());
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, new Object[]{e.getMessage(), e});
        }
        catch (SOAPFaultException e) {
            ConnectorExceptionUtils.processSOAPFault((SOAPFaultException)e);
            return null;
        }
    }

    @Override
    public GetAddedDocumentsResponse getAddedDocuments(X509Certificate certificate, PrivateKey privateKey, ParagraphAndVersesRequestType request) throws CivicsBusinessConnectorException, TechnicalConnectorException, SessionManagementException {
        try {
            GenericRequest service = this.getService(certificate, privateKey);
            GetAddedDocumentsRequest genRequest = new GetAddedDocumentsRequest();
            this.dozer(request, (ParagraphAndVersesRequestType)genRequest);
            service.setPayload((Object)genRequest);
            GenericResponse xmlResponse = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(service);
            return (GetAddedDocumentsResponse)xmlResponse.asObject(GetAddedDocumentsResponse.class);
        }
        catch (SOAPException e) {
            LOG.error(e.getMessage());
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, new Object[]{e.getMessage(), e});
        }
        catch (SOAPFaultException e) {
            ConnectorExceptionUtils.processSOAPFault((SOAPFaultException)e);
            return null;
        }
    }

    @Override
    public FindReimbursementConditionsResponse findReimbursementConditions(X509Certificate certificate, PrivateKey privateKey, FindReimbursementConditionsRequest request) throws CivicsBusinessConnectorException, TechnicalConnectorException, SessionManagementException {
        try {
            GenericRequest service = this.getService(certificate, privateKey);
            service.setPayload((Object)request);
            GenericResponse xmlResponse = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(service);
            return (FindReimbursementConditionsResponse)xmlResponse.asObject(FindReimbursementConditionsResponse.class);
        }
        catch (SOAPException e) {
            LOG.error(e.getMessage());
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, new Object[]{e.getMessage(), e});
        }
        catch (SOAPFaultException e) {
            ConnectorExceptionUtils.processSOAPFault((SOAPFaultException)e);
            return null;
        }
    }

    @Override
    public FindCNKResponse findCNK(X509Certificate certificate, PrivateKey privateKey, FindCNKRequest request) throws CivicsBusinessConnectorException, TechnicalConnectorException, SessionManagementException {
        try {
            GenericRequest service = this.getService(certificate, privateKey);
            service.setPayload((Object)request);
            GenericResponse xmlResponse = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(service);
            return (FindCNKResponse)xmlResponse.asObject(FindCNKResponse.class);
        }
        catch (SOAPException e) {
            LOG.error(e.getMessage());
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, new Object[]{e.getMessage(), e});
        }
        catch (SOAPFaultException e) {
            ConnectorExceptionUtils.processSOAPFault((SOAPFaultException)e);
            return null;
        }
    }

    private void dozer(ParagraphAndVersesRequestType source, ParagraphAndVersesRequestType destination) {
        destination.setChapterName(source.getChapterName());
        destination.setLanguage(source.getLanguage());
        destination.setParagraphName(source.getParagraphName());
        destination.setStartDate(source.getStartDate());
        destination.setVerseNumList(source.getVerseNumList());
        destination.setVersion(source.getVersion());
    }

    private void dozer(ParagraphRequestType source, ParagraphRequestType destination) {
        destination.setChapterName(source.getChapterName());
        destination.setLanguage(source.getLanguage());
        destination.setParagraphName(source.getParagraphName());
        destination.setStartDate(source.getStartDate());
        destination.setVersion(source.getVersion());
    }

    public void bootstrap() {
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindCNKRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindCNKResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindParagraphTextRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindParagraphTextResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindReimbursementConditionsRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindReimbursementConditionsResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetAddedDocumentsRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetAddedDocumentsResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetParagraphExclusionsRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetParagraphExclusionsResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetParagraphIncludedSpecialitiesRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetParagraphIncludedSpecialitiesResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetProfessionalAuthorisationsRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetProfessionalAuthorisationsResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{ParagraphAndVersesRequestType.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{ParagraphRequestType.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{SystemError.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{BusinessError.class});
    }
}

