﻿/*
 * Copyright (c) eHealth
 */
using System;
using NUnit.Framework;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.session;
using java.io;
using java.util;

using be.cin.mycarenet.esb.common.v2;
using be.cin.nip.async.generic;
using be.ehealth.business.mycarenetcommons.builders;
using be.ehealth.business.mycarenetcommons.domain;
using be.ehealth.businessconnector.genericasync.builders;
using be.ehealth.businessconnector.genericasync.domain;
using be.ehealth.technicalconnector.utils;
using be.ehealth.technicalconnector.config.util.domain;
using  be.ehealth.technicalconnector.config.util;
using be.ehealth.businessconnector.genericasync.mappers;
using be.fgov.ehealth.technicalconnector.tests.utils;

namespace be.ehealth.businessconnector.genericasync.integration
{
	[TestFixture]
	public class GenAsyncIntegrationTest
	{
		private static  String SERVICE_NAME = "dmg";
		
		[SetUp]
		public static void init() {
			SessionInitializer.init(".\\be.ehealth.businessconnector.genericasync.test.properties", SupportedLanguages.NET.getAbbreviation());
		}
		
		[TearDown]
		public static void tearDown() {
			Session.getInstance().unloadSession();
		}
		
		[Test]
		[Ignore("impossible to test without knowledge of business content , tests exist in other projects like dmg")]
		public void testConsultationList() {
			// Params
			bool istest = true;
			
			InputStream xmlFile = ConnectorIOUtils.getResourceAsStream(".\\examples\\PostConsultationListeXml.xml");
			//requestIdentifier must be identical to second part of kmehr id in the test xml file!!!!
			String requestIdentifier = "$$generated.id$$";
			byte[] content = ConnectorIOUtils.getBytes(xmlFile);
			BlobBuilder bbuilder = RequestBuilderFactory.getBlobBuilder("genericasync");
			Blob blob = bbuilder.build(content, "deflate", "_" + UUID.randomUUID().toString(), "text/xml");
			String messageName = "GMD-CONSULT-HCP";
			blob.setMessageName(messageName);
			GenAsyncIntegrationTestUtil.basePostTest(new GenAsyncIntegrationTestUtil.PostParameter(blob, istest, SERVICE_NAME, false, null, "urn:be:cin:nip:async:generic:post:msg", requestIdentifier));
		}
		
		[Test]
		public void testConfirmSuccessTackMessages() {
	        PackageInfo packageInfo = ConfigUtil.retrievePackageInfo(SERVICE_NAME);
	        CommonBuilder commonBuilder = RequestBuilderFactory.getCommonBuilder(SERVICE_NAME);
	        OrigineType origin = CommonInputMapper.mapOrigin(commonBuilder.createOrigin(packageInfo));
	        // by not providing the type of message, we receive all messages.
	        GetResponse getResponse = GenAsyncIntegrationTestUtil.get(origin, SERVICE_NAME);
	        // normally you would also process the contents in messages received in getResponse.
	        // this is skipped here
	        java.util.List msgResponsesToConfirm = new java.util.ArrayList();
	        java.util.List tackResponseToConfirm = new java.util.ArrayList();
	        // only confirm successes
	        tackResponseToConfirm.addAll(GenAsyncIntegrationTestUtil.selectTacksWithStatus(getResponse.getReturn().getTAckResponses(), GenericAsyncConstants.TACK_SUCCES));
	        if (tackResponseToConfirm.isEmpty() && msgResponsesToConfirm.isEmpty()) {
	        } else {
	        	GenAsyncIntegrationTestUtil.confirm(origin, SERVICE_NAME,new java.lang.Integer(300), tackResponseToConfirm, msgResponsesToConfirm);
	
	        }
		}
		
		[Test]
		public void testConfirmErrorTackMessages() {
			PackageInfo packageInfo = ConfigUtil.retrievePackageInfo(SERVICE_NAME);
			CommonBuilder commonBuilder = RequestBuilderFactory.getCommonBuilder(SERVICE_NAME);
			OrigineType origin = CommonInputMapper.mapOrigin(commonBuilder.createOrigin(packageInfo));
			// by not providing the type of message, we receive all messages.
			GetResponse getResponse = GenAsyncIntegrationTestUtil.get(origin, SERVICE_NAME, null);
			// normally you would also process the contents in messages received in getResponse.
			// this is skipped here
			java.util.List msgResponsesToConfirm = new java.util.ArrayList();
			java.util.List tackResponseToConfirm = new java.util.ArrayList();
			// only confirm errors
			tackResponseToConfirm.addAll(GenAsyncIntegrationTestUtil.selectTacksWithStatus(getResponse.getReturn().getTAckResponses(), GenericAsyncConstants.TACK_FAILURE));
			if (!msgResponsesToConfirm.isEmpty()) {
				GenAsyncIntegrationTestUtil.confirm(origin, SERVICE_NAME, new java.lang.Integer(300), tackResponseToConfirm, msgResponsesToConfirm);
			}
		}
	}
}
