﻿/*
 * Copyright (c) eHealth
 */
using System;
using be.ehealth.businessconnector.ehbox.api.domain;
using be.ehealth.businessconnector.ehbox.api.utils;
using be.ehealth.businessconnector.ehboxV2.session;
using be.ehealth.technicalconnector.idgenerator;
using be.fgov.ehealth.ehbox.consultation.protocol.v2;
using java.lang;
using java.util;
using NUnit.Framework;
using org.slf4j;

namespace be.ehealth.businessconnector.ehboxV2.testutil
{
	/// <summary>
	/// Description of EhboxTestUtil.
	/// </summary>
	public class EhboxTestUtil
	{
			
		private static Logger LOG = LoggerFactory.getLogger(typeof(EhboxTestUtil));
	
	    /**
	     * fixed test values to use.
	     */
	    public static string ANNEX_MIME_TYPE = "annex mimeType";
	
	    /**
	     * fixed test values to use.
	     */
	    public static string ANNEX_TITLE = "annex title";
	
	    /**
	     * fixed test values to use.
	     */
	    public static  string ANNEX_FILENAME = "annex filename";
	
	    /**
	     * fixed test values to use.
	     */
	    public static string PATIENT_INSS = "patientInss";
	
	    /**
	     * fixed test values to use.
	     */
	    public static QualityType MANDATEE_QUALITY = QualityType.PHARMACY_NIHII;
	
	    /**
	     * fixed test values to use.
	     */
	    public static string MANDATEE_ID = "1";
	
	    /**
	     * fixed test values to use.
	     */
	    public static string MANDATEE_APPLICATION_ID = "MANDATEE_APPLICATION_ID";
	
	    /**
	     * fixed test values to use.
	     */
	    public static string TITLE = "title";
	
	    /**
	     * fixed test values to use.
	     */
	    public static string MIME_TYPE = "mimeType";
	
	    /**
	     * fixed test values to use.
	     */
	    public static QualityType QUALITY = QualityType.GENERAL_PRACTIONER_SSIN;
	
	    /**
	     * fixed test values to use.
	     */
	    public static string ORGANIZATION_NAME = "organizationName";
	
	    /**
	     * fixed test values to use.
	     */
	    public static string LAST_NAME = "lastName";
	
	    /**
	     * fixed test values to use.
	     */
	    public static string ID = "82051234978";
	
	    /**
	     * fixed test values to use.
	     */
	    public static string FIRST_NAME = "firstName";
	
	    /**
	     * fixed test values to use.
	     */
	    public static string APPLICATION_ID = "applicationId";
	
	    /**
	     * fixed test values to use.
	     */
	    public static string FILENAME = "newFilename";
	
	    /**
	     * fixed test values to use.
	     */
	    public static string FREE_TEXT = "freeText";
	
	    /**
	     * @return we use deprecated methods ( test for ehbox v2, methods are deprecated for v3 )
	     */
	    public static DocumentMessage createFilledDocumentMessage() {
	        DocumentMessage message = new DocumentMessage();
	        message.setFreeText(EhboxTestUtil.FREE_TEXT);
	
	        message.setPatientInss(EhboxTestUtil.PATIENT_INSS);
	
	
	        // mandatee
	        message.setMandatee(new Addressee(EhboxTestUtil.MANDATEE_QUALITY.getIdentifierType()));
	        message.getMandatee().setApplicationId(EhboxTestUtil.MANDATEE_APPLICATION_ID);
	        message.getMandatee().setId(EhboxTestUtil.MANDATEE_QUALITY.getIdentifierType().formatIdentifierValue(Long.parseLong(EhboxTestUtil.MANDATEE_ID)));
	        message.getMandatee().setQuality(EhboxTestUtil.MANDATEE_QUALITY);
	
	        // destination
	        // using a doctor with ssin as destination , so no organisation name and application id
	        Addressee destinationToUse = new Addressee(EhboxTestUtil.QUALITY.getIdentifierType());
	        // destinationToUse.setApplicationId(EhboxTestUtil.APPLICATION_ID);
	        destinationToUse.setFirstName(EhboxTestUtil.FIRST_NAME);
	        destinationToUse.setId(EhboxTestUtil.ID);
	        destinationToUse.setLastName(EhboxTestUtil.LAST_NAME);
	        // destinationToUse.setOrganizationName(EhboxTestUtil.ORGANIZATION_NAME);
	        destinationToUse.setQuality(EhboxTestUtil.QUALITY);
	        message.getDestinations().add(destinationToUse);
	
	        //
	        message.setImportant(true);
	        message.setEncrypted(true);
	
	        // document
	        message.setDocument(new Document());
	        message.getDocument().setFilename(EhboxTestUtil.FILENAME);
	        message.getDocument().setMimeType(EhboxTestUtil.MIME_TYPE);
	        message.getDocument().setTitle(EhboxTestUtil.TITLE);
	        message.getDocument().setContent(System.Text.Encoding.UTF8.GetBytes ("blabla"));
	        // message.getDocument().setException(new UnsealConnectorException(UnsealConnectorExceptionValues.ERROR_CRYPTO, (Throwable) null,
	        // "Content is null"));
	
	        // annex
	        Document annex = new Document();
	        annex.setFilename(EhboxTestUtil.ANNEX_FILENAME);
	        annex.setMimeType(EhboxTestUtil.ANNEX_MIME_TYPE);
	        annex.setTitle(EhboxTestUtil.ANNEX_TITLE);
	        annex.setContent(System.Text.Encoding.UTF8.GetBytes ("blabla"));
	
	        message.getAnnexList().add(annex);
	        return message;
	    }
	    
	    /**
	     * @return
	     * @throws TechnicalConnectorException
	     */
	    public static string generatePublicationId() {
	        string generatedId = IdGeneratorFactory.getIdGenerator().generateId();
	        string truncatedId = generatedId.Substring(1, 13);
	        return truncatedId;
	    }
	    
	    public static java.util.List getInboxMessages() {
	        return getMessagesForSource("INBOX");
	    }
	
	    public static java.util.List getMessagesForSource(string source) {
	        GetMessagesListRequest request = new GetMessagesListRequest();
	        request.setSource(source);
	        GetMessageListResponseType messageList = ServiceFactory.getEhealthBoxServiceV2().getMessageList(request);
	        Assert.IsTrue("100" == messageList.getStatus().getCode());
	        return messageList.getMessages();
	    }
	
	    /**
	     * @param messages the messages to log
	     * @throws EhboxBusinessConnectorException 
	     * @throws TechnicalConnectorException 
	     * @throws SessionManagementException 
	     * 
	     */
	    public static void logMessages(java.util.List messages) {
	        StringBuilder sb = new StringBuilder();
	        for (int i=0;i<messages.size();i++) {
	        	be.fgov.ehealth.ehbox.consultation.protocol.v2.Message message = (be.fgov.ehealth.ehbox.consultation.protocol.v2.Message)messages.get(i);
	            logMessage(message, sb);
	        }
	        LOG.debug("logMessages : messages in list are : " + sb.toString());
	    }
	
	    /**
	     * @param message
	     */
	    private static void logMessage(be.fgov.ehealth.ehbox.consultation.protocol.v2.Message message, StringBuilder sb) {
	       
	        sb.append("\n");
	        sb.append("messageId").append(message.getMessageId()).append(" ");
	        sb.append("type").append(message.getContentInfo().getContentType()).append(" ");
	        sb.append("title").append(message.getContentInfo().getTitle()).append(" ");
	        sb.append("applicationName").append(message.getContentSpecification().getApplicationName()).append(" ");
	        sb.append("publicationDate").append(message.getMessageInfo().getPublicationDate()).append(" ");
	        sb.append("size").append(message.getMessageInfo().getSize()).append(" ");
	        
	    }
	}
}
