﻿/*
 * Copyright (c) eHealth
 */
using System;
using NUnit.Framework;
using java.util;

using be.ehealth.businessconnector.ehbox.api.domain;
using be.ehealth.businessconnector.ehboxV2.builders;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.fgov.ehealth.commons.protocol.v1;
using be.fgov.ehealth.ehbox.consultation.protocol.v2;
using be.ehealth.businessconnector.ehboxV2.session;

namespace be.ehealth.businessconnector.ehboxV2.session
{
	/**
	 * eHealthBox Service Integration Tests This test shows the use of the eHealthBox Service through the use of the Business Connector.
	 * 
	 * The tests below use the Session Management Service to manage the session and SAML/STS token. The eHealthBox of the test user specified in
	 * the business connector property file is used, these tests expect that this is set to a valid INSS of a citizen.
	 */
	[TestFixture]
	public class EhboxV2ServiceConsultationIntegrationTest : AbstractEhboxV2IntegrationTest
	{

		
		/**
		 * Response ID
		 */
		private String messageId;
		
		/**
		 * Initialise messageID if not already done
		 * 
		 * @throws Exception
		 */
		
		[SetUp]
		public void setup()
		{
			/*
			 * Create the parameters of the new message
			 */
			// set the folder (INBOX | SENTBOX | BININBOX | BINSENTBOX)
			String source = "INBOX";
			
			GetMessagesListRequest request = new GetMessagesListRequest();
			request.setSource(source);
			
			
			/*
			 * Invoke the business connector framework's eHealthBox's getMessageList operation
			 */
			
			EhealthBoxServiceV2 service = ServiceFactory.getEhealthBoxServiceV2();
			GetMessageListResponseType response = service.getMessageList(request);
			
			/*
			 * Verify the response
			 */
			// check if there are no errors
			Assert.AreEqual("100", response.getStatus().getCode());
			// check if a messageId has been returned
			Assert.IsNotNull(response.getMessages());
			// print out the messageId's for the given folder
			java.util.List list = response.getMessages();
			if (list.size() > 0) {
				messageId = ((be.fgov.ehealth.ehbox.consultation.protocol.v2.Message)list.get(0)).getMessageId();
			}
		}
		
		
		/**
		 * Test the getBoxInfo operation from the eHealthBox Service through the use of the Business Connector. The getBoxInfo retrieves general
		 * info about an eHealthBox
		 * 
		 * The following main steps are done: - Invoke the business connector - Verify the response
		 * 
		 * @throws Exception
		 */
		[Test]
		public void testGetBoxInfo() {
			/*
			 * Invoke the business connector framework's eHealthBox's getBoxInfo operation
			 */
			EhealthBoxServiceV2 service = ServiceFactory.getEhealthBoxServiceV2();
			GetBoxInfoRequest getBoxInfoRequest = new GetBoxInfoRequest();
			GetBoxInfoResponse response = service.getBoxInfo(getBoxInfoRequest);
			
			/*
			 * Verify the response
			 */
			// check if there are no errors
			Assert.AreEqual("100", response.getStatus().getCode());
			// check if there is any content
			Assert.IsNotNull(response.getBoxId());
		}
		
		/**
		 * Test the getMessageList operation from the eHealthBox Service through the use of the Business Connector. This test retrieves the
		 * messageId's of the message's in a given folder, correct values for the folder are: INBOX | SENT | BIN
		 * 
		 * The following main steps are done: - Create the parameters of the new message - Invoke the business connector - Verify the response
		 * 
		 * @throws Exception
		 */
		[Test]
		public void testGetMessageList() {
			/*
			 * Create the parameters of the new message
			 */
			// set the folder (INBOX | SENTBOX | BININBOX | BINSENTBOX)
			String source = "INBOX";
			
			GetMessagesListRequest request = new GetMessagesListRequest();
			request.setSource(source);
			
			
			/*
			 * Invoke the business connector framework's eHealthBox's getMessageList operation
			 */
			
			EhealthBoxServiceV2 service = ServiceFactory.getEhealthBoxServiceV2();
			GetMessageListResponseType response = service.getMessageList(request);
			
			/*
			 * Verify the response
			 */
			// check if there are no errors
			Assert.AreEqual("100", response.getStatus().getCode());
			// check if a messageId has been returned
			Assert.IsNotNull(response.getMessages());
			// print out the messageId's for the given folder
			java.util.List list = response.getMessages();
			
			for (int i = 0; i<list.size() ; i++)  {
				be.fgov.ehealth.ehbox.consultation.protocol.v2.Message message = (be.fgov.ehealth.ehbox.consultation.protocol.v2.Message)list.get(i);
				
				// JAXB.marshal(message, System.out);
				be.ehealth.businessconnector.ehbox.api.domain.Message msg = BuilderFactory.getConsultationMessageBuilder().buildMessage(message);
				
			}
		}
		
		

		/**
		 * Test the getFullMessage operation from the eHealthBox Service through the use of the Business Connector. This test retrieves a full
		 * message based on a given messageId's. Usually the messageId is retrieved first from the getMessageList operation.
		 * 
		 * The following main steps are done: - Create the parameters of the new message - Invoke the business connector - Verify the response
		 * 
		 * @throws Exception
		 */
		[Test]
		[Ignore]
		public void testGetFullMessage() {
			/*
			 * Create the parameters of the new message
			 */
			MessageRequestType request = new MessageRequestType();
			// set the messageId, use the messageId of the message that has been sent in testSendMessage
			
			request.setMessageId("1000000815190");
			request.setSource("INBOX");
			
			/*
			 * Invoke the business connector framework's eHealthBox's getFullMessage operation
			 */
			
			EhealthBoxServiceV2 service = ServiceFactory.getEhealthBoxServiceV2();
			GetFullMessageResponse response = service.getFullMessage(request);
			
			/*
			 * Verify the response
			 */
			
			// check if the message has been returned
			Assert.IsNotNull(response.getMessage().getPublicationId());
			be.ehealth.businessconnector.ehbox.api.domain.Message msg = BuilderFactory.getConsultationMessageBuilder().buildFullMessage(response);
			if (msg.GetType() == typeof(DocumentMessage)) {
				DocumentMessage message = (DocumentMessage) msg;
			} else if (msg.GetType() == typeof(NewsMessage)) {
				NewsMessage message = (NewsMessage) msg;
			}
		}
		
		
	}
}
