﻿/*
 * Copyright (c) eHealth
 */
using System;
using be.ehealth.businessconnector.ehboxV2.testutil;
using ikvm.extensions;
using NUnit.Framework;
using java.util;
using be.ehealth.businessconnector.ehbox.api.domain;
using be.ehealth.businessconnector.ehbox.api.utils;
using be.ehealth.businessconnector.ehboxV2.builders;
using be.ehealth.businessconnector.ehboxV2.exception;
using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.service.sts.security;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.ehealth.technicalconnector.session;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.commons.protocol.v1;
using be.fgov.ehealth.ehbox.consultation.protocol.v2;
using be.fgov.ehealth.ehbox.publication.protocol.v2;
using be.ehealth.technicalconnector.validator.impl;
using be.ehealth.businessconnector.ehboxV2.validator.impl;

namespace be.ehealth.businessconnector.ehboxV2.service
{
	/**
	 * eHealthBox Service Integration Tests This test shows the use of the eHealthBox Service through the use of the Business Connector.
	 * 
	 * The tests below use the Session Management Service to manage the session and SAML/STS token. The eHealthBox of the test user specified in
	 * the business connector property file is used, these tests expect that this is set to a valid INSS of a citizen.
	 */
	[TestFixture]
	public class ConsultationServiceImplIntegrationTest : AbstractEhboxV2IntegrationTest
	{
		
		private static SAMLToken token;
		
		/**
		 * Id of the response
		 */
		private static String messageId;
		
		
		/**
		 * Initialize messageId if not already done
		 * @throws Exception
		 */
		[SetUp]
		public void setup() {

	        /*
	         * Create the parameters of the new message
	         */
	        // set the folder (INBOX | SENTBOX | BININBOX | BINSENTBOX)
	        String source = "INBOX";
	
	        GetMessagesListRequest request = new GetMessagesListRequest();
	        request.setSource(source);
	
	
	        /*
	         * Invoke the business connector framework's eHealthBox's getMessageList operation
	         */
	        token = Session.getInstance().getSession().getSAMLToken();
	        EhBoxConsultationPortType service = ServiceFactory.getConsultationService(token);
	        GetMessageListResponseType response = service.getMessagesList(request);
	
	        /*
	         * Verify the response
	         */
	        // check if there are no errors
	        Assert.AreEqual("100", response.getStatus().getCode());
	        // check if a messageId has been returned
	        Assert.NotNull(response.getMessages());
	        // print out the messageId's for the given folder
	        java.util.List list = response.getMessages();
	
	        if (list.size() > 0) {
	        	be.fgov.ehealth.ehbox.consultation.protocol.v2.Message msg = (be.fgov.ehealth.ehbox.consultation.protocol.v2.Message)list.get(0);
	            messageId = msg.getMessageId();
	        }

		}
		
		
		/**
		 * Test the getMessageList operation from the eHealthBox Service through the use of the Business Connector. This test retrieves the
		 * messageId's of the message's in a given folder, correct values for the folder are: INBOX | SENT | BIN
		 * 
		 * The following main steps are done: - Create the parameters of the new message - Invoke the business connector - Verify the response
		 * 
		 * @throws Exception
		 */
		[Test]
		public void testDeleteMessage() {
			/*
			 * Create the parameters of the message to delete
			 */
			// set the folder (INBOX | SENTBOX | BININBOX | BINSENTBOX)
			String source = "INBOX";

			DeleteMessageRequest request = new DeleteMessageRequest();
			request.setSource(source);
			request.getMessageIds().add(messageId);


			/*
			 * Invoke the business connector framework's eHealthBox's deleteMessage operation
			 */
			token = Session.getInstance().getSession().getSAMLToken();
			EhBoxConsultationPortType service = ServiceFactory.getConsultationService(token);
			DeleteMessageResponse response = service.deleteMessage(request);

			/*
			 * Verify the response
			 */
			// check if there are no errors
			Assert.AreEqual("100", response.getStatus().getCode());
		}
		
		
		/**
		 * Test the getBoxInfo operation from the eHealthBox Service through the use of the Business Connector. The getBoxInfo retrieves general
		 * info about an eHealthBox
		 * 
		 * The following main steps are done: - Invoke the business connector - Verify the response
		 * 
		 * @throws TechnicalConnectorException the technical connector exception
		 * @throws EhboxBusinessConnectorException the business connector exception
		 */
		[Test]
		public void testGetBoxInfo() {
			/*
			 * Invoke the business connector framework's eHealthBox's getBoxInfo operation
			 */
			token = Session.getInstance().getSession().getSAMLToken();
			EhBoxConsultationPortType service = ServiceFactory.getConsultationService(token);
			GetBoxInfoRequest getBoxInfoRequest = new GetBoxInfoRequest();
			GetBoxInfoResponse response = service.getBoxInfo(getBoxInfoRequest);

			/*
			 * Verify the response
			 */
			// check if there are no errors
			Assert.AreEqual("100", response.getStatus().getCode());
			// check if there is any content
			Assert.IsNotNull(response.getBoxId());
		}
		
		/**
		 * Test the getMessageList operation from the eHealthBox Service through the use of the Business Connector. This test retrieves the
		 * messageId's of the message's in a given folder, correct values for the folder are: INBOX | SENT | BIN
		 * 
		 * The following main steps are done: - Create the parameters of the new message - Invoke the business connector - Verify the response
		 * 
		 * @throws TechnicalConnectorException the technical connector exception
		 * @throws EhboxBusinessConnectorException the business connector exception
		 */
		[Test]
		public void testGetMessageList() {
			/*
	         * Create the parameters of the new message
	         */
	        // set the folder (INBOX | SENTBOX | BININBOX | BINSENTBOX)
	        String source = "INBOX";
	
	        GetMessagesListRequest request = new GetMessagesListRequest();
	        request.setSource(source);
	
	
	        /*
	         * Invoke the business connector framework's eHealthBox's getMessageList operation
	         */
	        token = Session.getInstance().getSession().getSAMLToken();
	        EhBoxConsultationPortType service = ServiceFactory.getConsultationService(token);
	        GetMessageListResponseType response = service.getMessagesList(request);
	
	        /*
	         * Verify the response
	         */
	        // check if there are no errors
	        Assert.AreEqual("100", response.getStatus().getCode());
	        // check if a messageId has been returned
	        Assert.NotNull(response.getMessages());
	        // print out the messageId's for the given folder
	        java.util.List list = response.getMessages();
	        for (int i=0;i<list.size();i++) {
	        	be.fgov.ehealth.ehbox.consultation.protocol.v2.Message message = (be.fgov.ehealth.ehbox.consultation.protocol.v2.Message)list.get(i);
	            // JAXB.marshal(message, System.out);
	            be.ehealth.businessconnector.ehbox.api.domain.Message msg = BuilderFactory.getConsultationMessageBuilder().buildMessage(message);
	            if (msg.GetType() == typeof(NewsMessage)) {
	                NewsMessage news = (NewsMessage) msg;
	
	            } else if (msg.GetType() == typeof(DocumentMessage)) {
	                DocumentMessage doc = (DocumentMessage) msg;
	            }
	        }
		}
		
		/**
		 * Test the getFullMessage operation from the eHealthBox Service through the use of the Business Connector. This test retrieves a full
		 * message based on a given messageId's. Usually the messageId is retrieved first from the getMessageList operation.
		 * 
		 * The following main steps are done: - Create the parameters of the new message - Invoke the business connector - Verify the response
		 * 
		 * @throws InterruptedException the interrupted exception
		 * @throws TechnicalConnectorException the technical connector exception
		 * @throws EhboxBusinessConnectorException the business connector exception
		 */
		[Test]
		[Ignore]
		public void testGetFullMessage()  {
	        /*
	         * Create the parameters of the new message
	         */
	        MessageRequestType request = new MessageRequestType();
	        // set the messageId, use the messageId of the message that has been sent in testSendMessage
	        request.setMessageId("1000000815190");
	        request.setSource("INBOX");
	
	        /*
	         * Invoke the business connector framework's eHealthBox's getFullMessage operation
	         */
	
	        token = Session.getInstance().getSession().getSAMLToken();
	        EhBoxConsultationPortType service = ServiceFactory.getConsultationService(token);
	        GetFullMessageResponse response = service.getFullMessage(request);
	
	        /*
	         * Verify the response
	         */
	
	        // check if the message has been returned
	        Assert.NotNull(response.getMessage().getPublicationId());
	        be.ehealth.businessconnector.ehbox.api.domain.Message msg = BuilderFactory.getConsultationMessageBuilder().buildFullMessage(response);
	        if (msg.GetType() == typeof(DocumentMessage)) {
	            DocumentMessage message = (DocumentMessage) msg;
	        } else if (msg.GetType() == typeof(NewsMessage)) {
	            NewsMessage message = (NewsMessage) msg;
	        }
		}
		
		
		/**
		 * Test the getHistory operation from the eHealthBox Service through the use of the Business Connector. This test retrieves the history
		 * based on a given messageId. the list that is returned is a list of Strings containing messageId's.
		 * 
		 * The following main steps are done: - Create the parameters of the new message - Invoke the business connector - Verify the response
		 * 
		 * @throws TechnicalConnectorException the technical connector exception
		 * @throws EhboxBusinessConnectorException the business connector exception
		 */
		[Test]
		public void testGetHistory() {
			/*
			 * Create the parameters of the new message
			 */
			MessageRequestType request = new MessageRequestType();
			// set the messageId, use the messageId of the message that has been sent in testSendMessage
			request.setMessageId(messageId);
			request.setSource("INBOX");
			
			/*
			 * Invoke the business connector framework's eHealthBox's getFullMessage operation
			 */
			token = Session.getInstance().getSession().getSAMLToken();
			
			EhBoxConsultationPortType service = ServiceFactory.getConsultationService(token);
			GetHistoryResponse response = service.getMessageHistory(request);
			
			/*
			 * Verify the response
			 */
			// check if there are no errors
			Assert.AreEqual("100", response.getStatus().getCode());
			// check if the message has been returned
			Assert.IsNotNull(response.getMessageIds());
		}
		
		/**
		 * Test the moveToInbox operation from the eHealthBox Service through the use of the Business Connector. This moves a message from the
		 * BIN folder to the INBOX folder based on a given messageId.
		 * 
		 * The following main steps are done: - Create the parameters of the new message - Invoke the business connector - Verify the response
		 * 
		 * @throws TechnicalConnectorException the technical connector exception
		 * @throws EhboxBusinessConnectorException the business connector exception
		 */
		[Test]
		public void testMoveToInbox() {
	     	token = Session.getInstance().getSession().getSAMLToken();
	        EhBoxPublicationPortType publicationService = ServiceFactory.getPublicationService(token);
	        SendMessageResponse sendMessage = publicationService.sendMessage(BuilderFactory.getSendMessageBuilder().buildMessage(EhboxTestUtil.createFilledDocumentMessage()));
	        String sendMessageId = sendMessage.getId();
	        Assert.AreEqual("100", sendMessage.getStatus().getCode());
	        EhBoxConsultationPortType service = ServiceFactory.getConsultationService(token);
	        GetMessagesListRequest messagesListRequest = new GetMessagesListRequest();
	        messagesListRequest.setSource("SENTBOX");
	        GetMessageListResponseType messageList = service.getMessagesList(messagesListRequest);
	        Assert.AreEqual("100", messageList.getStatus().getCode());
	        Assert.IsTrue(messageList.getMessages().size() > 1);
	       be.fgov.ehealth.ehbox.consultation.protocol.v2.Message msg = (be.fgov.ehealth.ehbox.consultation.protocol.v2.Message)messageList.getMessages().get(0);
	        String messageIdToUse = msg.getMessageId();
	
	        /*
	         * Create the parameters of the new message
	         */
	        MoveMessageRequest request = new MoveMessageRequest();
	        // set the messageId, use the messageId of the message that has been sent in testSendMessage
	        request.getMessageIds().add(messageIdToUse);
	        request.setSource("SENTBOX");
	        request.setDestination("BINSENTBOX");
	
	        /*
	         * Invoke the business connector framework's eHealthBox's getFullMessage operation
	         */
	
	        token = Session.getInstance().getSession().getSAMLToken();
	        // EhBoxConsultationPortType service = ServiceFactory.getConsultationService(token);
	        ResponseType response = service.moveMessage(request);
	
	
	        /*
	         * Verify the response
	         */
	        // check if there are no errors
	        Assert.AreEqual("100", response.getStatus().getCode());
		}
	}
}
