﻿/*
 * Copyright (c) eHealth
 */
using System;
using NUnit.Framework;
using java.io;
using java.net;


using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.chap4.protocol.v1;

using org.joda.time;

using be.ehealth.businessconnector.chapterIV.builders;
using be.fgov.ehealth.standards.kmehr.id.v1;
using be.fgov.ehealth.standards.kmehr.schema.v1;

/**
 * test utilities.
 * 
 * @author EHP
 * 
 */
namespace be.ehealth.businessconnector.chapterIV.testutil
{
	public class TestUtils
	{
		private static KmehrBuilder kmehrBuilder;
		
		
		
		/**
		 * private constructor, non instatiation needed ,only static methods.
		 */
		private TestUtils() {
		}
		
		
		public static ConsultChap4MedicalAdvisorAgreementResponse mapToConsultResponseObject(String fileLocation)  {
			InputStream ios = ConnectorIOUtils.getResourceAsStream(fileLocation);
			
			MarshallerHelper helper = new MarshallerHelper(
				typeof(ConsultChap4MedicalAdvisorAgreementResponse), typeof(ConsultChap4MedicalAdvisorAgreementResponse));
			return (ConsultChap4MedicalAdvisorAgreementResponse) helper.toObject(ios);
			
		}
		
		public static String getFileContents(String fileLocation)  {
			return ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream(fileLocation));
		}
		
		/**
		 * @param expectedFileLocation
		 * @param actual
		 * @throws TechnicalConnectorException
		 */
		public static void compareContents(String expectedFileLocation, String actual)  {
			Assert.AreEqual(getFileContents(expectedFileLocation), actual);
		}
		
		public static KmehrBuilder getKmehrBuilder()  {
			if (kmehrBuilder == null) {
				kmehrBuilder = KmehrBuilderFactory.getKmehrBuilder();
			}
			return kmehrBuilder;
		}
		
		public static FolderType updateFolderWithAuthorAndCurrentDate(FolderType folder, String patientInss) {
			if (folder != null) {
				for (int i = 0; i<folder.getTransactions().size();i++) {
					TransactionType transaction = (TransactionType)folder.getTransactions().get(i);
					
					transaction.setAuthor(getKmehrBuilder().generateAuthor());
					transaction.setDate(new org.joda.time.DateTime());
					transaction.setTime(new org.joda.time.DateTime());
				}
				
				for (int i = 0; i<folder.getPatient().getIds().size();i++) {
					IDPATIENT idPatient = (IDPATIENT) folder.getPatient().getIds().get(i);
					
					idPatient.setValue(patientInss);
				}
			}
			return folder;
		}
		
		
		/**
		 * @param message
		 * @return
		 * @throws TechnicalConnectorException
		 */
		public static FolderType updateFolderWithAuthorAndCurrentDate(FolderType folder)  {
			if (folder != null) {
				for (int i = 0; i<folder.getTransactions().size() ;i++ ) {
					TransactionType transaction = (TransactionType)folder.getTransactions().get(i);
					transaction.setAuthor(getKmehrBuilder().generateAuthor());
					transaction.setDate(new org.joda.time.DateTime());
					transaction.setTime(new org.joda.time.DateTime());
				}
			}
			return folder;
		}

	}
}
