﻿/*
 * Copyright (c) eHealth
 */
using System;
using be.ehealth.businessconnector.chapterIV.integration;
using NUnit.Framework;
using java.io;

using org.joda.time;
using be.ehealth.businessconnector.chapterIV.builders;
using be.ehealth.businessconnector.chapterIV.domain;
using be.ehealth.businessconnector.chapterIV.exception;
using be.ehealth.businessconnector.chapterIV.session;
using be.ehealth.businessconnector.chapterIV.testutil;
using be.ehealth.businessconnector.chapterIV.utils;
using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.chap4.protocol.v1;
using be.fgov.ehealth.standards.kmehr.schema.v1;

namespace be.ehealth.businessconnector.chapterIV.integration
{
	/**
	 * Integration test for ChapterIV business connector
	 * 
	 * @author EHP
	 * 
	 */
	[TestFixture]
	public class ChapterIVConsultationIntegrationTest: AbstractChapterIV
	{
		/**
		 * 
		 * @throws Exception
		 */
		[Test]
		public void testConsultationValidRequestOA100() {
			InputStream xmlResourceInputStream = ConnectorIOUtils.getResourceAsStream(".\\examples\\sample-chapter4-consultation-request-with-ssin.xml");
			performTestConsultation(xmlResourceInputStream, "81032034303");
		}
		
		/**
		 * 
		 * @throws Exception
		 */
		[Test]
		public void testConsultationValidRequestOA500() {
			InputStream xmlResourceInputStream = ConnectorIOUtils.getResourceAsStream(".\\examples\\sample-chapter4-consultation-request-with-ssin.xml");
			performTestConsultation(xmlResourceInputStream, "76011402195");
		}
		
		/**
		 * @param xmlResourceInputStream
		 * @throws ConnectorException
		 * @throws TechnicalConnectorException
		 * @throws ChapterIVBusinessConnectorException
		 * @throws SessionManagementException
		 * @throws UnsealConnectorException
		 */
		private void performTestConsultation(InputStream xmlResourceInputStream, String patientInss) {
			ChapterIVService service = ChapterIVSessionServiceFactory.getChapterIVService();
			FolderType folder = parseFolderType(xmlResourceInputStream);
			
			folder = TestUtils.updateFolderWithAuthorAndCurrentDate(folder, patientInss);
			
			try {
				org.joda.time.DateTime agreementStartDate = FolderTypeUtils.retrieveConsultationStartDateOrAgreementStartDate(folder);
				ChapterIVReferences references = new ChapterIVReferences(true);
				ConsultationBuilder builder = BuilderFactory.getBuilderFactoryForSession().getConsultationBuilder();
				
				ChapterIVBuilderResponse builderResponse = builder.build(folder, true, references, agreementStartDate);
				ConsultChap4MedicalAdvisorAgreementResponse response = service.consultChap4MedicalAdvisorAgreement(builderResponse.getConsultChap4MedicalAdvisorAgreementRequest());
				ChapterIVKmehrResponseWithTimeStampInfo retrievedKmehrResponse = getResponseBuilder().validateTimestampAndretrieveChapterIVKmehrResponseWithTimeStampInfo(response);
				Assert.IsNotNull(retrievedKmehrResponse);
				Assert.IsNotNull(retrievedKmehrResponse.getKmehrresponse());
				Assert.IsNotNull(retrievedKmehrResponse.getKmehrresponse().getRequest());
				Assert.IsNotNull(retrievedKmehrResponse.getKmehrresponse().getRequest().getKmehrmessage());
				Assert.IsNotNull(retrievedKmehrResponse.getTimeStampResponse());
				Assert.IsNotNull(retrievedKmehrResponse.getKmehrResponseBytes());
				Assert.IsNotNull(retrievedKmehrResponse.getTimeStampBytes());
			} catch (SoaErrorException e) {
				processError(e, "ConsultationValid");
			} catch (ChapterIVBusinessConnectorException e) {
				processChapterIvBusinessException(service, e);
			}
		}
	}
}
