/*
 * Copyright (c) eHealth
 */
package be.fgov.ehealth.technicalconnector.bootstrap.bcp;

import java.util.Arrays;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

import be.fgov.ehealth.technicalconnector.bootstrap.bcp.domain.EndPointInformation;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.EndpointUpdateRule;

/**
 * @author EH053
 *
 */
public class EndpointDistributorTest {

    @Rule
    public EndpointUpdateRule rule = new EndpointUpdateRule("/local/servicelist-local");

    @Test
    public void oneServiceNoBCP() throws Exception {

        EndPointInformation info = new EndPointInformation();
        info.register("service:1", "http://localhost:6666", "http://localhost:6666", Arrays.asList("http://localhost:6666", "http://localhost:6667"));
        EndpointDistributor dist = EndpointDistributor.getInstance();
        dist.activatePolling();
        Assert.assertTrue(dist.mustPoll());
        dist.update(info);
        Assert.assertFalse(dist.mustPoll());
    }

    @Test
    public void oneServiceBCP() throws Exception {
        EndPointInformation info = new EndPointInformation();
        info.register("service:1", "http://localhost:6666", "http://localhost:6667", Arrays.asList("http://localhost:6666", "http://localhost:6667"));
        EndpointDistributor dist = EndpointDistributor.getInstance();
        dist.activatePolling();
        Assert.assertTrue(dist.mustPoll());
        dist.update(info);
        Assert.assertTrue(dist.mustPoll());
    }

    @Test
    public void twoServiceNoBCP() throws Exception {

        EndPointInformation info = new EndPointInformation();
        info.register("service:1", "http://localhost:6666", "http://localhost:6666", Arrays.asList("http://localhost:6666", "http://localhost:6667"));
        info.register("service:2", "http://localhost:7777", "http://localhost:7777", Arrays.asList("http://localhost:7777", "http://localhost:7777"));
        EndpointDistributor dist = EndpointDistributor.getInstance();
        dist.activatePolling();
        Assert.assertTrue(dist.mustPoll());
        dist.update(info);
        Assert.assertFalse(dist.mustPoll());
    }

    @Test
    public void twoServiceBCP() throws Exception {

        EndPointInformation info = new EndPointInformation();
        info.register("service:1", "http://localhost:6666", "http://localhost:6667", Arrays.asList("http://localhost:6666", "http://localhost:6667"));
        info.register("service:2", "http://localhost:7777", "http://localhost:7777", Arrays.asList("http://localhost:7777", "http://localhost:7777"));
        EndpointDistributor dist = EndpointDistributor.getInstance();
        dist.activatePolling();
        Assert.assertTrue(dist.mustPoll());
        dist.update(info);
        Assert.assertTrue(dist.mustPoll());
    }
}
