/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.genericasync.builders.impl;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

import be.cin.nip.async.generic.GetResponse;
import be.ehealth.businessconnector.genericasync.builders.ResponseObjectBuilder;
import be.ehealth.businessconnector.genericasync.exception.GenAsyncBusinessConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.MarshallerHelper;
import be.fgov.ehealth.technicalconnector.tests.session.SessionInitializer;


/**
 * test response object builder , with xades validation. needs remote connection to sts.
 * 
 * @author EHP
 * 
 */
public class ResponseObjectBuilderIntegrationTest {

    @BeforeClass
    public static void init() throws Exception {
        SessionInitializer.init("/be.ehealth.businessconnector.genericasync.test.properties");
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Session.getInstance().unloadSession();
    }

    private ResponseObjectBuilder builder = new ResponseObjectBuilderImpl();


    /**
     * Test method for
     * {@link be.ehealth.businessconnector.genericasync.builders.impl.ResponseObjectBuilderImpl#handleGetResponse(be.cin.nip.async.generic.GetResponse)}
     * .
     */
    @Test
    public void testHandleGetResponse() throws GenAsyncBusinessConnectorException, TechnicalConnectorException {
        MarshallerHelper<GetResponse, GetResponse> helper = new MarshallerHelper<GetResponse, GetResponse>(GetResponse.class, GetResponse.class);
        try {
            builder.handleGetResponse(helper.toObject(ConnectorIOUtils.getBytes(ConnectorIOUtils.getResourceAsStream("/examples/GetResponseWithXades.xml"))));
            Assert.fail("should throw Exception : the certificate is expired");
        } catch (GenAsyncBusinessConnectorException e) {
            Assert.assertEquals("Embedded signature is invalid.", e.getMessage());
        }
    }

    /**
     * Test method for
     * {@link be.ehealth.businessconnector.genericasync.builders.impl.ResponseObjectBuilderImpl#handleGetResponse(be.cin.nip.async.generic.GetResponse)}
     * .
     */
    @Test(expected = GenAsyncBusinessConnectorException.class)
    public void testHandleGetResponseInvalidXades() throws GenAsyncBusinessConnectorException, TechnicalConnectorException {

        MarshallerHelper<GetResponse, GetResponse> helper = new MarshallerHelper<GetResponse, GetResponse>(GetResponse.class, GetResponse.class);
        builder.handleGetResponse(helper.toObject(ConnectorIOUtils.getBytes(ConnectorIOUtils.getResourceAsStream("/examples/GetResponseWithInvalidXades.xml"))));
    }
}
