/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.ehboxV2.session;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import be.ehealth.businessconnector.ehbox.api.domain.Addressee;
import be.ehealth.businessconnector.ehbox.api.domain.Document;
import be.ehealth.businessconnector.ehbox.api.domain.DocumentMessage;
import be.ehealth.businessconnector.ehbox.api.utils.QualityType;
import be.ehealth.businessconnector.ehboxV2.builders.BuilderFactory;
import be.ehealth.businessconnector.ehboxV2.builders.SendMessageBuilder;
import be.ehealth.businessconnector.ehboxV2.testutil.EhboxTestUtil;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.utils.IdentifierType;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.GetMessageListResponseType;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.GetMessagesListRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.Message;
import be.fgov.ehealth.ehbox.publication.protocol.v2.SendMessageRequest;
import be.fgov.ehealth.ehbox.publication.protocol.v2.SendMessageResponse;
import be.fgov.ehealth.technicalconnector.tests.session.SessionInitializer;


/**
 * Tries to reproduce problem where encrypted message result in unreadable encrypted patient niss field.
 * 
 * @author EH076
 * 
 * @since
 * 
 */
public class DecryptionProblemNissIntegrationTest {

    private static final Logger LOG = LoggerFactory.getLogger(DecryptionProblemNissIntegrationTest.class);

    @BeforeClass
    public static void initSession() throws Exception {
        Session.getInstance().unloadSession();
        SessionInitializer.init("/be.ehealth.businessconnector.ehboxv2.test.properties");
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Session.getInstance().unloadSession();
    }

    @Test
    public void test() throws Exception {
        /*
         * Create the parameters of the new message
         */
        SendMessageBuilder builder = BuilderFactory.getSendMessageBuilder();

        DocumentMessage<Message> documentMsg = new DocumentMessage<Message>();
        documentMsg.setPublicationId(EhboxTestUtil.generatePublicationId());
        List<Addressee> addresseeList = new ArrayList<Addressee>();
        Addressee addressee = new Addressee(IdentifierType.SSIN);
        addressee.setId("82051234978");
        addressee.setQuality(QualityType.GENERAL_PRACTIONER_SSIN);
        addresseeList.add(addressee);
        final List<Addressee> destination = addresseeList;
        documentMsg.setDestinations(destination);
        documentMsg.setImportant(false);

        documentMsg.setPatientInss("82051234978");

        Document doc = new Document();
        doc.setTitle("Document " + new Date());
        doc.setContent("TEST".getBytes());
        doc.setMimeType("text/plain");
        doc.setFilename("be.ehealth.businessconnector.properties");
        documentMsg.setDocument(doc);


        SendMessageRequest request = builder.buildMessage(documentMsg);
        /*
         * Invoke the business connector framework's eHealthBox's sendMessage operation
         */
        EhealthBoxServiceV2 service = ServiceFactory.getEhealthBoxServiceV2();
        SendMessageResponse response = service.sendMessage(request);

        /*
         * Verify the response
         */
        // check if there are no errors
        Assert.assertEquals("100", response.getStatus().getCode());
        // check if a messageId has been returned
        Assert.assertNotNull(response.getId());

        LOG.debug("Message Sent: " + response.getId());

        String source = "INBOX";

        GetMessagesListRequest getMessagesListRequest = new GetMessagesListRequest();
        getMessagesListRequest.setSource(source);


        /*
         * Invoke the business connector framework's eHealthBox's getMessageList operation
         */

        GetMessageListResponseType getMessagesListResponse = service.getMessageList(getMessagesListRequest);

        /*
         * Verify the response
         */
        // check if there are no errors
        Assert.assertEquals("100", getMessagesListResponse.getStatus().getCode());
        // check if a messageId has been returned
        Assert.assertNotNull(getMessagesListResponse.getMessages());
        // print out the messageId's for the given folder
        List<Message> list = getMessagesListResponse.getMessages();
        LOG.info("Messages in " + source);

        for (Message message : list) {
            // JAXB.marshal(message, System.out);
            be.ehealth.businessconnector.ehbox.api.domain.Message<Message> msg = BuilderFactory.getConsultationMessageBuilder().buildMessage(message);
            LOG.debug("read message " + msg.getId());
        }
    }


}
