/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.ehboxV2.exception;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.text.MessageFormat;

import org.junit.Test;

import be.fgov.ehealth.errors.soa.v1.SOAErrorType;


/**
 * Class test for {@link EhboxBusinessConnectorException}
 * 
 * @author EHP
 * 
 */
public class EhboxBusinessConnectorExceptionTest {

    /**
     * Creates an EhboxBusinessConnectorException without any string param to complete the error message
     */
    @Test
    public void testEhboxBusinessConnectorExceptionNoParam() {
        EhboxBusinessConnectorExceptionValues errorValue = EhboxBusinessConnectorExceptionValues.INVALID_EHBOX_NEWS_NEWSTITLE;
        EhboxBusinessConnectorException error = new EhboxBusinessConnectorException(errorValue, new SOAErrorType());
        assertEquals(error.getErrorCode(), EhboxBusinessConnectorExceptionValues.INVALID_EHBOX_NEWS_NEWSTITLE.getErrorCode());
        assertEquals(error.getMessage(), EhboxBusinessConnectorExceptionValues.INVALID_EHBOX_NEWS_NEWSTITLE.getMessage());
        assertNotNull(error.getSOAError());
    }

    /**
     * Creates a new EhBoxBusinessConnectorException with string params to complete the error message
     */
    @Test
    public void testEhboxBusinessConnectorExceptionParams() {
        EhboxBusinessConnectorExceptionValues errorValue = EhboxBusinessConnectorExceptionValues.ERROR_EHBOX_DOCUMENT_OUTPUTSTREAM;
        EhboxBusinessConnectorException error = new EhboxBusinessConnectorException(errorValue, new SOAErrorType(), "test");
        assertEquals(error.getErrorCode(), EhboxBusinessConnectorExceptionValues.ERROR_EHBOX_DOCUMENT_OUTPUTSTREAM.getErrorCode());
        assertEquals(error.getMessage(), MessageFormat.format(EhboxBusinessConnectorExceptionValues.ERROR_EHBOX_DOCUMENT_OUTPUTSTREAM.getMessage(), "test"));
        assertNotNull(error.getSOAError());
    }

}
