/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.civics.service;

import java.io.InputStream;
import java.net.URL;

import javax.xml.XMLConstants;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;

import org.apache.commons.lang.ArrayUtils;
import org.junit.Assert;
import org.junit.Test;

import be.ehealth.technicalconnector.handler.SchemaValidatorHandler;


/**
 * Test class for {@link ServiceFactory}
 * 
 * @author EHP
 * 
 */
public class ServiceFactoryTest {


    /**
     * Test if all the xsd needed by the ServiceFactory are present on the classpath.
     * 
     * @throws Exception
     */
    @Test
    public void testXSDPresent() throws Exception {
        SchemaFactory schemaFactory = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
        Source[] sources = new Source[]{};


        if (ServiceFactory.CIVICS_XSD.length == 1) {
            URL schemaurl = SchemaValidatorHandler.class.getResource(ServiceFactory.CIVICS_XSD[0]);
            schemaFactory.newSchema(schemaurl);

        } else {
            for (String xsd : ServiceFactory.CIVICS_XSD) {
                InputStream in = ServiceFactoryTest.class.getResourceAsStream(xsd);
                Assert.assertNotNull("Could not find file:" + xsd, in);
                Source source = new StreamSource(in);
                sources = (Source[]) ArrayUtils.add(sources, source);
            }

            schemaFactory.newSchema(sources);
        }
    }
}
