/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.chapterIV.validators.impl;

import java.io.InputStream;

import javax.xml.bind.JAXB;

import org.junit.Assert;
import org.junit.Test;

import be.ehealth.businessconnector.chapterIV.builders.impl.ConsultationBuilderImpl;
import be.ehealth.businessconnector.chapterIV.validators.KmehrValidator;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.fgov.ehealth.standards.kmehr.schema.v1.Kmehrmessage;


/**
 * Test class for {@link KmehrValidatorImpl}
 * 
 * @author EHP
 * 
 */
public class KmehrValidatorImplTest {

    private static final String KMEHR_LOCATION = "/XSD/kmehr/kmehr_elements-1_5.xsd";

    /**
     * @throws Exception
     */
    @Test
    public void testValidXML() throws Exception {
        Kmehrmessage message = JAXB.unmarshal(ConsultationBuilderImpl.class.getResourceAsStream("/examples/sample-chapter4-consultation-request-with-ssin-kmehr.xml"), Kmehrmessage.class);
        KmehrValidator validator = new KmehrValidatorImpl();
        validator.validateKmehrMessage(message);
    }

    @Test
    public void testLoadXSDFromClassPath() throws Exception {
        InputStream inputStream = ConnectorIOUtils.getResourceAsStream(KMEHR_LOCATION);
        Assert.assertNotNull(inputStream);

    }

}
