/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.commons.eid.client;

public enum FileType {
    Identity(new byte[]{63, 0, -33, 1, 64, 49}, 179),
    IdentitySignature(new byte[]{63, 0, -33, 1, 64, 50}, 128),
    Address(new byte[]{63, 0, -33, 1, 64, 51}, 121),
    AddressSignature(new byte[]{63, 0, -33, 1, 64, 52}, 128),
    Photo(new byte[]{63, 0, -33, 1, 64, 53}, 3064),
    AuthentificationCertificate(new byte[]{63, 0, -33, 0, 80, 56}, 1061, 130),
    NonRepudiationCertificate(new byte[]{63, 0, -33, 0, 80, 57}, 1082, 131),
    CACertificate(new byte[]{63, 0, -33, 0, 80, 58}, 1044),
    RootCertificate(new byte[]{63, 0, -33, 0, 80, 59}, 914),
    RRNCertificate(new byte[]{63, 0, -33, 0, 80, 60}, 820);

    private final byte[] fileId;
    private final byte keyId;
    private final int estimatedMaxSize;

    private FileType(byte[] fileId, int estimatedMaxSize) {
        this.fileId = fileId;
        this.keyId = (byte)-1;
        this.estimatedMaxSize = estimatedMaxSize;
    }

    private FileType(byte[] fileId, int estimatedMaxSize, int keyId) {
        this.fileId = fileId;
        this.keyId = (byte)keyId;
        this.estimatedMaxSize = estimatedMaxSize;
    }

    public byte[] getFileId() {
        return this.fileId;
    }

    public byte getKeyId() {
        return this.keyId;
    }

    public boolean isCertificateUserCanSignWith() {
        return this.keyId != -1;
    }

    public boolean chainIncludesCitizenCA() {
        return this.isCertificateUserCanSignWith();
    }

    public int getEstimatedMaxSize() {
        return this.estimatedMaxSize;
    }
}

