/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.ehboxV2.service.impl;

import be.ehealth.businessconnector.ehbox.api.domain.exception.EhboxBusinessConnectorException;
import be.ehealth.businessconnector.ehbox.api.domain.exception.EhboxBusinessConnectorExceptionValues;
import be.ehealth.businessconnector.ehboxV2.service.PublicationService;
import be.ehealth.businessconnector.ehboxV2.service.ServiceFactory;
import be.ehealth.businessconnector.ehboxV2.validator.EhboxReplyValidator;
import be.ehealth.technicalconnector.exception.SessionManagementException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.validator.SessionValidator;
import be.fgov.ehealth.commons.protocol.v1.ResponseType;
import be.fgov.ehealth.ehbox.publication.protocol.v2.BusinessError;
import be.fgov.ehealth.ehbox.publication.protocol.v2.EhBoxPublicationPortType;
import be.fgov.ehealth.ehbox.publication.protocol.v2.SendMessageRequest;
import be.fgov.ehealth.ehbox.publication.protocol.v2.SendMessageResponse;
import be.fgov.ehealth.ehbox.publication.protocol.v2.SystemError;
import be.fgov.ehealth.errors.core.v1.LocalisedStringType;
import java.net.MalformedURLException;

public class PublicationServiceImpl
implements PublicationService {
    private EhboxReplyValidator replyValidator;
    private SessionValidator sessionValidator;

    public PublicationServiceImpl(SessionValidator sessionValidator, EhboxReplyValidator replyValidator) {
        this.replyValidator = replyValidator;
        this.sessionValidator = sessionValidator;
    }

    private EhBoxPublicationPortType getPublicationService(SAMLToken token) throws TechnicalConnectorException, EhboxBusinessConnectorException, SessionManagementException {
        try {
            this.sessionValidator.validateSession();
            EhBoxPublicationPortType publicationPortType = ServiceFactory.getPublicationService(token);
            return publicationPortType;
        }
        catch (MalformedURLException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.MALFORMED_URL, (Throwable)e, new Object[]{""});
        }
    }

    @Override
    public SendMessageResponse sendMessage(SAMLToken token, SendMessageRequest sendMessageRequestType) throws TechnicalConnectorException, EhboxBusinessConnectorException, SessionManagementException {
        SendMessageResponse response;
        try {
            response = this.getPublicationService(token).sendMessage(sendMessageRequestType);
        }
        catch (BusinessError e) {
            throw new EhboxBusinessConnectorException(EhboxBusinessConnectorExceptionValues.ERROR_BUSINESS_CODE_REASON, (Throwable)e, new Object[]{e.getFaultInfo().getCode(), e.getFaultInfo().getCode(), ((LocalisedStringType)e.getFaultInfo().getMessages().get(0)).getValue()});
        }
        catch (SystemError e) {
            throw new EhboxBusinessConnectorException(EhboxBusinessConnectorExceptionValues.ERROR_BUSINESS_CODE_REASON, (Throwable)e, new Object[]{e.getFaultInfo().getCode(), e.getFaultInfo().getCode(), ((LocalisedStringType)e.getFaultInfo().getMessages().get(0)).getValue()});
        }
        this.replyValidator.validateReplyStatus((ResponseType)response);
        return response;
    }
}

