/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.ehboxV2.service;

import be.ehealth.businessconnector.ehbox.api.domain.exception.EhboxBusinessConnectorException;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.ConfigValidator;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.handler.LoggingHandler;
import be.ehealth.technicalconnector.handler.SAMLHolderOfKeyHandler;
import be.ehealth.technicalconnector.handler.SchemaValidatorHandler;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.EhBoxConsultationPortType;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.EhBoxConsultationService;
import be.fgov.ehealth.ehbox.publication.protocol.v2.EhBoxPublicationPortType;
import be.fgov.ehealth.ehbox.publication.protocol.v2.EhBoxPublicationService;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;

public final class ServiceFactory {
    private static final String WSDL_EHBOX_PUB = "/WSDL/ehealthbox_publication_v2.wsdl";
    private static final String WSDL_EHBOX_CONS = "/WSDL/ehealthbox_consultation_v2.wsdl";
    private static List<String> expectedProps = new ArrayList<String>();
    private static ConfigValidator config;
    public static final String PROP_ENDPOINT_CONSULTATION_V2 = "endpoint.ehbox.consultation.v2";
    public static final String PROP_ENDPOINT_PUBLICATION_V2 = "endpoint.ehbox.publication.v2";
    public static final String PROP_VALIDATION_INCOMING_EHBOX_V2 = "validation.incoming.ehbox.v2.message";
    private static final String XML = "/XSD/external/xml.xsd";
    private static final String EH_COMMONS_PROT = "/XSD/common/ehealth-commons-schema-protocol-1_6.xsd";
    private static final String EH_COMMONS_CORE = "/XSD/common/ehealth-commons-schema-core-1_6.xsd";
    private static final String ERROR_SOA_CORE = "/XSD/common/ehealth-errors-schema-core-1_0.xsd";
    private static final String ERROR_SOA = "/XSD/common/ehealth-errors-schema-soa-1_0.xsd";
    private static final String EHBOX_CONS_PROT = "/XSD/ehbox_v2/ehealth-ehBox-consultation-schema-protocol-2_0.xsd";
    private static final String EHBOX_PUB_PROT = "/XSD/ehbox_v2/ehealth-ehBox-publication-schema-protocol-2_0.xsd";
    private static final String EHBOX_CORE = "/XSD/ehbox_v2/ehealth-ehBox-schema-core-2_0.xsd";
    protected static final String[] EHBOXV2_CONS_XSD;
    protected static final String[] EHBOXV2_PUB_XSD;

    private ServiceFactory() {
    }

    public static EhBoxConsultationPortType getConsultationService(SAMLToken token) throws MalformedURLException, TechnicalConnectorException, EhboxBusinessConnectorException {
        URL wsdlUrl = ServiceFactory.class.getResource(WSDL_EHBOX_CONS);
        EhBoxConsultationService consultationService = new EhBoxConsultationService(wsdlUrl, new QName("urn:be:fgov:ehealth:ehbox:consultation:protocol:v2", "ehBoxConsultationService"));
        EhBoxConsultationPortType consultationPortType = consultationService.getEhBoxConsultationPort();
        ((BindingProvider)consultationPortType).getRequestContext().put("javax.xml.ws.service.endpoint.address", config.getProperty(PROP_ENDPOINT_CONSULTATION_V2));
        Binding binding = ((BindingProvider)consultationPortType).getBinding();
        List handlerChain = binding.getHandlerChain();
        if ("true".equalsIgnoreCase(config.getProperty(PROP_VALIDATION_INCOMING_EHBOX_V2))) {
            handlerChain.add(new SchemaValidatorHandler(3, EHBOXV2_CONS_XSD));
        } else {
            handlerChain.add(new SchemaValidatorHandler(2, EHBOXV2_CONS_XSD));
        }
        handlerChain.add(new SAMLHolderOfKeyHandler(token));
        handlerChain.add(new LoggingHandler());
        binding.setHandlerChain(handlerChain);
        return consultationPortType;
    }

    public static EhBoxPublicationPortType getPublicationService(SAMLToken token) throws MalformedURLException, TechnicalConnectorException, EhboxBusinessConnectorException {
        URL wsdlUrl = ServiceFactory.class.getResource(WSDL_EHBOX_PUB);
        EhBoxPublicationService publicationService = new EhBoxPublicationService(wsdlUrl, new QName("urn:be:fgov:ehealth:ehbox:publication:protocol:v2", "ehBoxPublicationService"));
        EhBoxPublicationPortType publicationPortType = publicationService.getEhBoxPublicationPort();
        ((BindingProvider)publicationPortType).getRequestContext().put("javax.xml.ws.service.endpoint.address", config.getProperty(PROP_ENDPOINT_PUBLICATION_V2));
        Binding binding = ((BindingProvider)publicationPortType).getBinding();
        List handlerChain = binding.getHandlerChain();
        if ("true".equalsIgnoreCase(config.getProperty(PROP_VALIDATION_INCOMING_EHBOX_V2))) {
            handlerChain.add(new SchemaValidatorHandler(3, EHBOXV2_PUB_XSD));
        } else {
            handlerChain.add(new SchemaValidatorHandler(2, EHBOXV2_PUB_XSD));
        }
        handlerChain.add(new SAMLHolderOfKeyHandler(token));
        handlerChain.add(new LoggingHandler());
        binding.setHandlerChain(handlerChain);
        return publicationPortType;
    }

    static {
        EHBOXV2_CONS_XSD = new String[]{XML, ERROR_SOA_CORE, ERROR_SOA, EH_COMMONS_CORE, EH_COMMONS_PROT, EHBOX_CORE, EHBOX_CONS_PROT};
        EHBOXV2_PUB_XSD = new String[]{XML, ERROR_SOA_CORE, ERROR_SOA, EH_COMMONS_CORE, EH_COMMONS_PROT, EHBOX_CORE, EHBOX_PUB_PROT};
        expectedProps.add(PROP_ENDPOINT_CONSULTATION_V2);
        expectedProps.add(PROP_ENDPOINT_PUBLICATION_V2);
        expectedProps.add(PROP_VALIDATION_INCOMING_EHBOX_V2);
        config = ConfigFactory.getConfigValidator(expectedProps);
    }
}

