/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.chapterIV.validators.impl;

import be.ehealth.businessconnector.chapterIV.exception.ChapterIVBusinessConnectorException;
import be.ehealth.businessconnector.chapterIV.exception.ChapterIVBusinessConnectorExceptionValues;
import be.ehealth.businessconnector.chapterIV.validators.KmehrValidator;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.validator.ValidatorHelper;
import be.fgov.ehealth.errors.soa.v1.SOAErrorType;
import be.fgov.ehealth.standards.kmehr.schema.v1.FolderType;
import be.fgov.ehealth.standards.kmehr.schema.v1.Kmehrmessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KmehrValidatorImpl
implements KmehrValidator {
    private static final Logger LOG = LoggerFactory.getLogger(KmehrValidatorImpl.class);
    private static final String KMEHR_LOCATION = "/XSD/kmehr/kmehr_elements-1_5.xsd";

    @Override
    public void validateKmehrMessage(Kmehrmessage msg) throws TechnicalConnectorException, ChapterIVBusinessConnectorException {
        ValidatorHelper.validate((Object)msg, Kmehrmessage.class, (String)KMEHR_LOCATION);
        if (msg.getFolders().size() > 1) {
            LOG.debug("\t## XML is not correct: Only 1 folder is supported : throwing Chapter IV business connector exception");
            throw new ChapterIVBusinessConnectorException(ChapterIVBusinessConnectorExceptionValues.ERROR_XML_KMEHRVALIDATOR, (SOAErrorType)null, "Only 1 folder is supported");
        }
        if (((FolderType)msg.getFolders().get(0)).getPatient().getIds().size() < 1) {
            LOG.debug("\t## XML is not correct: Patient must have at least one Id : throwing Chapter IV business connector exception");
            throw new ChapterIVBusinessConnectorException(ChapterIVBusinessConnectorExceptionValues.ERROR_XML_KMEHRVALIDATOR, (SOAErrorType)null, "Patient must have at least one Id");
        }
    }
}

