/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.hub.security;

import be.ehealth.businessconnector.hub.exception.IntraHubBusinessConnectorException;
import be.ehealth.businessconnector.hub.exception.IntraHubBusinessConnectorExceptionValues;
import be.ehealth.businessconnector.hub.security.HubRequestHandler;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.SessionUtil;
import be.fgov.ehealth.hubservices.core.v1.RequestType;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDHCPARTY;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDHCPARTYschemes;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDHCPARTYvalues;
import be.fgov.ehealth.standards.kmehr.id.v1.IDHCPARTY;
import be.fgov.ehealth.standards.kmehr.id.v1.IDHCPARTYschemes;
import be.fgov.ehealth.standards.kmehr.id.v1.IDKMEHR;
import be.fgov.ehealth.standards.kmehr.id.v1.IDKMEHRschemes;
import be.fgov.ehealth.standards.kmehr.schema.v1.AuthorType;
import be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HubRequestDoctor
implements HubRequestHandler {
    private static final String USER_PROFESSION = "user.kmerhprofession";
    private static final Logger LOG = LoggerFactory.getLogger(HubRequestDoctor.class);
    private static final String USER_FIRSTNAME = "user.firstname";
    private static final String USER_LASTNAME = "user.lastname";
    private static List<String> expectedProps = new ArrayList<String>();
    private static Configuration config;

    @Override
    public RequestType handle() throws IntraHubBusinessConnectorException {
        RequestType baseInfo = new RequestType();
        baseInfo.setDate(new DateTime());
        baseInfo.setTime(new DateTime());
        baseInfo.setId(this.createMessageId(this.getNihii()));
        AuthorType author = new AuthorType();
        ArrayList<HcpartyType> lst = new ArrayList<HcpartyType>();
        lst.add(this.getDoctorAsHCParty(this.getNihii(), this.getNiss()));
        author.getHcparties().addAll(lst);
        baseInfo.setAuthor(author);
        return baseInfo;
    }

    private String getNiss() throws IntraHubBusinessConnectorException {
        try {
            return SessionUtil.getNiss();
        }
        catch (TechnicalConnectorException e) {
            LOG.warn(e.getMessage());
            throw new IntraHubBusinessConnectorException(IntraHubBusinessConnectorExceptionValues.ERROR, e, e.getMessage());
        }
    }

    private String getNihii() throws IntraHubBusinessConnectorException {
        try {
            return SessionUtil.getNihii();
        }
        catch (TechnicalConnectorException e) {
            LOG.warn(e.getMessage());
            throw new IntraHubBusinessConnectorException(IntraHubBusinessConnectorExceptionValues.ERROR, e, e.getMessage());
        }
    }

    private HcpartyType getDoctorAsHCParty(String nihii, String niss) {
        HcpartyType hcParty = new HcpartyType();
        IDHCPARTY doctorNISS = new IDHCPARTY();
        IDHCPARTY doctorNIHII = new IDHCPARTY();
        CDHCPARTY hcPartytype = new CDHCPARTY();
        doctorNIHII.setS(IDHCPARTYschemes.ID_HCPARTY);
        doctorNIHII.setSV("1.0");
        doctorNIHII.setValue(nihii);
        doctorNISS.setS(IDHCPARTYschemes.INSS);
        doctorNISS.setSV("1.0");
        doctorNISS.setValue(niss);
        hcPartytype.setS(CDHCPARTYschemes.CD_HCPARTY);
        hcPartytype.setSV("1.1");
        hcPartytype.setValue(config.getProperty(USER_PROFESSION, CDHCPARTYvalues.PERSPHYSICIAN.value()));
        ArrayList<IDHCPARTY> idList = new ArrayList<IDHCPARTY>();
        idList.add(doctorNIHII);
        idList.add(doctorNISS);
        ArrayList<CDHCPARTY> cdList = new ArrayList<CDHCPARTY>();
        cdList.add(hcPartytype);
        hcParty.getIds().addAll(idList);
        hcParty.getCds().addAll(cdList);
        hcParty.setFamilyname(config.getProperty(USER_LASTNAME));
        hcParty.setFirstname(config.getProperty(USER_FIRSTNAME));
        return hcParty;
    }

    private IDKMEHR createMessageId(String nihii) {
        String strID = "";
        strID = StringUtils.isEmpty((CharSequence)nihii) ? UUID.randomUUID().toString() : nihii + "." + this.transformDate(Calendar.getInstance());
        IDKMEHR id = new IDKMEHR();
        id.setS(IDKMEHRschemes.ID_KMEHR);
        id.setSV("1.0");
        id.setValue(strID);
        return id;
    }

    private String transformDate(Calendar cal) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        return sdf.format(cal.getTime());
    }

    static {
        expectedProps.add(USER_FIRSTNAME);
        expectedProps.add(USER_LASTNAME);
        config = ConfigFactory.getConfigValidator(expectedProps);
    }
}

