/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.bootstrap.utils;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BootStrapUtils {
    private static final String PROP_STORETYPE_JKS = "JKS";
    public static final String EXT_SHA2 = ".sha2";
    public static final String EXT_XML = ".xml";
    private static final Logger LOG = LoggerFactory.getLogger(BootStrapUtils.class);
    private static final String CERTIFICATE_BEGIN = "-----BEGIN CERTIFICATE-----";
    private static final String CERTIFICATE_END = "-----END CERTIFICATE-----";
    private static final String CERTIFICATE_TYPE = "X.509";
    private static final String LF = System.getProperty("line.separator");

    private BootStrapUtils() {
        throw new UnsupportedOperationException();
    }

    public static X509Certificate generateX509Cert(String input) throws TechnicalConnectorException {
        X509Certificate x509Certificate;
        StringBuilder x509base64 = new StringBuilder();
        if (!input.contains(CERTIFICATE_BEGIN)) {
            x509base64.append(CERTIFICATE_BEGIN).append(LF);
        }
        x509base64.append(input);
        if (!input.contains(CERTIFICATE_END)) {
            x509base64.append(LF).append(CERTIFICATE_END);
        }
        byte[] bytes = x509base64.toString().trim().getBytes();
        ByteArrayInputStream bais = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance(CERTIFICATE_TYPE);
            bais = new ByteArrayInputStream(bytes);
            x509Certificate = (X509Certificate)cf.generateCertificate(bais);
        }
        catch (CertificateException e) {
            try {
                throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_IOEXCEPTION, (Throwable)e, new Object[0]);
            }
            catch (Throwable throwable) {
                ConnectorIOUtils.closeQuietly(bais);
                throw throwable;
            }
        }
        ConnectorIOUtils.closeQuietly((Object)bais);
        return x509Certificate;
    }

    public static void writeKeyStore(List<X509Certificate> certList, String location, char[] pwd) throws TechnicalConnectorException {
        FileOutputStream fos = null;
        try {
            File file = new File(location);
            if (!file.exists()) {
                LOG.debug("Create new file [" + location + "]");
                if (!file.createNewFile()) {
                    throw new IOException("Unable to create file");
                }
            }
            if (!file.canWrite()) {
                LOG.info("Unable to write on file [" + location + "], skipping write keystore.");
                return;
            }
            KeyStore store = KeyStore.getInstance(PROP_STORETYPE_JKS);
            store.load(null, pwd);
            for (int i = 0; i < certList.size(); ++i) {
                X509Certificate cert = certList.get(i);
                String alias = BootStrapUtils.getAlias(i, cert);
                store.setCertificateEntry(alias, cert);
            }
            fos = new FileOutputStream(file);
            store.store(fos, pwd);
            ConnectorIOUtils.closeQuietly((Object)fos);
        }
        catch (Exception e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_IOEXCEPTION, (Throwable)e, new Object[]{location});
        }
        finally {
            ConnectorIOUtils.closeQuietly(fos);
        }
    }

    private static String getAlias(int i, X509Certificate cert) {
        return StringUtils.leftPad((String)Integer.toString(i), (int)3, (String)"0") + " " + cert.getSubjectX500Principal().getName("RFC2253");
    }

    public static void merge(String inputLocation, char[] inputPwd, String targetLocation, char[] targetPwd) throws TechnicalConnectorException {
        FileOutputStream fos = null;
        try {
            File file = new File(targetLocation);
            if (!file.exists()) {
                LOG.debug("Create new file [" + targetLocation + "]");
                file.createNewFile();
            }
            if (!file.canWrite()) {
                LOG.info("Unable to write on file [" + targetLocation + "], skipping write keystore.");
                return;
            }
            KeyStore source = KeyStore.getInstance(PROP_STORETYPE_JKS);
            source.load(ConnectorIOUtils.getResourceAsStream((String)inputLocation), inputPwd);
            KeyStore target = KeyStore.getInstance(PROP_STORETYPE_JKS);
            target.load(ConnectorIOUtils.getResourceAsStream((String)targetLocation), targetPwd);
            Enumeration<String> aliases = source.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                X509Certificate cert = (X509Certificate)source.getCertificate(alias);
                if (!BootStrapUtils.isSelfSigned(cert)) continue;
                target.setCertificateEntry(BootStrapUtils.getAlias(target.size() + 1, cert), cert);
            }
            fos = new FileOutputStream(file);
            target.store(fos, targetPwd);
            ConnectorIOUtils.closeQuietly((Object)fos);
        }
        catch (Exception e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.UNKNOWN_ERROR, (Throwable)e, new Object[]{"while merging keystore [" + inputLocation + "] into [" + targetLocation + "]"});
        }
        finally {
            ConnectorIOUtils.closeQuietly(fos);
        }
    }

    private static boolean isSelfSigned(X509Certificate cert) {
        try {
            cert.verify(cert.getPublicKey());
            return true;
        }
        catch (Exception e) {
            LOG.debug("Certificate is not selfsigned.", (Throwable)e);
            return false;
        }
    }
}

