/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.ws.impl.strategy;

import be.ehealth.technicalconnector.exception.NoNextEndpointException;
import be.ehealth.technicalconnector.exception.RetryNextEndpointException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.ws.domain.GenericResponse;
import be.ehealth.technicalconnector.ws.impl.AbstractWsSender;
import be.ehealth.technicalconnector.ws.impl.strategy.InvokeStrategy;
import be.fgov.ehealth.technicalconnector.bootstrap.bcp.EndpointDistributor;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryStrategy
extends AbstractWsSender
implements InvokeStrategy {
    private static Logger LOG = LoggerFactory.getLogger(RetryStrategy.class);
    private static EndpointDistributor distributor = EndpointDistributor.getInstance();

    @Override
    public GenericResponse invoke(SOAPMessageContext request, Handler<?>[] chain) throws TechnicalConnectorException {
        RetryContext ctx = new RetryContext((String)request.get((Object)"javax.xml.ws.service.endpoint.address"));
        return this.invoke(ctx, request, chain);
    }

    private GenericResponse invoke(RetryContext ctx, SOAPMessageContext request, Handler<?>[] chain) throws TechnicalConnectorException {
        int alternatives = distributor.getAmountOfAlternatives(ctx.endpoint);
        for (int i = 0; i < alternatives; ++i) {
            String activeEndpoint = distributor.getActiveEndpoint(ctx.endpoint);
            if (!ctx.invokedEndpoints.contains(activeEndpoint)) {
                ctx.invokedEndpoints.add(activeEndpoint);
                try {
                    GenericResponse resp = AbstractWsSender.call(request, chain);
                    if (ctx.alternativeActivated) {
                        LOG.debug("Activating status page polling!");
                        distributor.activatePolling();
                    }
                    return resp;
                }
                catch (RetryNextEndpointException e) {
                    LOG.error("Unable to invoke endpoint [{}], activating next one.", request.get((Object)"javax.xml.ws.service.endpoint.address"), (Object)e);
                    try {
                        distributor.activateNextEndPoint(activeEndpoint);
                        ctx.alternativeActivated = true;
                    }
                    catch (NoNextEndpointException nonext) {
                        LOG.error("Unable to activate alternative", (Throwable)nonext);
                    }
                    ctx.lastException = e;
                    continue;
                }
            }
            LOG.debug("Endpoint [{}] already invoked, skipping it.", (Object)activeEndpoint);
        }
        if (EndpointDistributor.update()) {
            return this.invoke(ctx, request, chain);
        }
        throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, ExceptionUtils.getRootCause((Throwable)ctx.lastException), ExceptionUtils.getRootCauseMessage((Throwable)ctx.lastException));
    }

    private static class RetryContext {
        protected String endpoint;
        protected Exception lastException;
        protected boolean alternativeActivated;
        protected List<String> invokedEndpoints = new ArrayList<String>();

        public RetryContext(String endpoint) {
            this.endpoint = endpoint;
        }
    }
}

