/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.service.sts.security.impl;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.ConfigValidator;
import be.ehealth.technicalconnector.exception.CredentialException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.sts.security.KeyStoreFactory;
import be.ehealth.technicalconnector.service.sts.security.impl.AbstractExtendedCredential;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.session.SessionServiceWithCache;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BeIDCredential
extends AbstractExtendedCredential
implements SessionServiceWithCache {
    private static final Logger LOG = LoggerFactory.getLogger(BeIDCredential.class);
    private static Map<String, BeIDCredential> instancesMap = new HashMap<String, BeIDCredential>();
    private static ConfigValidator config = ConfigFactory.getConfigValidator();
    public static final String PROP_USE_CACHE = "be.ehealth.technicalconnector.service.sts.security.impl.beidcredential.cache";
    @Deprecated
    public static final String OID_LASTNAME = BCStyle.SURNAME.getId();
    @Deprecated
    public static final String OID_GIVENNAME = BCStyle.GIVENNAME.getId();
    @Deprecated
    public static final String OID_SERIALNUMBER = BCStyle.SN.getId();
    public static final String EID_AUTH_ALIAS = "Authentication";
    public static final String EID_SIGN_ALIAS = "Signature";
    private String eidAlias;
    private KeyStore keyStore;
    private Map<String, X509Certificate> certCache = new HashMap<String, X509Certificate>();

    private BeIDCredential(String alias) {
        this.eidAlias = alias;
        Session.getInstance().registerSessionService(this);
    }

    public static BeIDCredential getInstance(String scope, String aliasName) throws TechnicalConnectorException {
        String key = scope + "-" + aliasName;
        boolean useCache = config.getBooleanProperty(PROP_USE_CACHE, Boolean.FALSE);
        if (useCache && instancesMap.containsKey(key)) {
            LOG.debug("Returning cached instance.");
            return instancesMap.get(key);
        }
        BeIDCredential newInstance = new BeIDCredential(aliasName);
        if (useCache) {
            instancesMap.put(key, newInstance);
        }
        return newInstance;
    }

    @Override
    public PrivateKey getPrivateKey() {
        try {
            if (!this.getKeyStore().isKeyEntry(this.getAlias())) {
                LOG.error("No Private key '" + this.getAlias() + "' in the keystore");
            }
            return (PrivateKey)this.getKeyStore().getKey(this.getAlias(), null);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            throw new CredentialException(e);
        }
    }

    @Override
    public PublicKey getPublicKey() {
        if (this.getCertificate() == null) {
            LOG.error("Unable to read the certificate of the EID");
            return null;
        }
        return this.getCertificate().getPublicKey();
    }

    @Override
    public X509Certificate getCertificate() {
        X509Certificate certificate = null;
        try {
            if (!this.certCache.containsKey(this.getAlias())) {
                this.certCache.put(this.getAlias(), (X509Certificate)this.getKeyStore().getCertificate(this.getAlias()));
            }
            certificate = this.certCache.get(this.getAlias());
        }
        catch (Exception e) {
            LOG.warn("getCertificate()", (Throwable)e);
        }
        return certificate;
    }

    private String getAlias() {
        String eidAutAlias = null;
        try {
            Enumeration<String> aliases = this.getKeyStore().aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!this.getKeyStore().isKeyEntry(alias) || !alias.equalsIgnoreCase(this.eidAlias)) continue;
                eidAutAlias = alias;
                break;
            }
        }
        catch (Exception e) {
            this.keyStore = null;
            LOG.warn("Unable to deterimine alias", (Throwable)e);
        }
        return eidAutAlias;
    }

    @Override
    public String getIssuer() {
        if (this.getCertificate() == null) {
            LOG.error("Unable to read the certificate of the EID");
            return null;
        }
        if (this.getCertificate().getSubjectDN() == null) {
            LOG.error("Unable to read the SubjectDN of the EID");
            return null;
        }
        X509Certificate cert = this.getCertificate();
        this.logDebug("getIssuer: (RFC1779)" + cert.getSubjectX500Principal().getName("RFC1779"));
        return cert.getSubjectX500Principal().getName("RFC1779");
    }

    @Override
    public String getIssuerQualifier() {
        if (this.getCertificate() == null) {
            LOG.error("Unable to read the certificate of the EID");
            return null;
        }
        if (this.getCertificate().getIssuerX500Principal() == null) {
            LOG.error("Unable to read the certificate/IssuerX500Principal of the EID");
            return null;
        }
        X509Certificate cert = this.getCertificate();
        this.logDebug("getIssuerQualifier: (RFC1779)" + cert.getIssuerX500Principal().getName("RFC1779"));
        return cert.getIssuerX500Principal().getName("RFC1779");
    }

    @Override
    public KeyStore getKeyStore() throws TechnicalConnectorException {
        if (this.keyStore == null) {
            this.keyStore = KeyStoreFactory.getKeyStore();
        }
        return this.keyStore;
    }

    @Override
    public String getProviderName() {
        return this.keyStore.getProvider().getName();
    }

    private void logDebug(String message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(message);
        }
    }

    @Override
    public void flushCache() {
        this.certCache.clear();
    }

    @Override
    public Certificate[] getCertificateChain() {
        try {
            return this.getKeyStore().getCertificateChain(this.getAlias());
        }
        catch (KeyStoreException e) {
            LOG.error(e.getMessage());
            throw new CredentialException(e);
        }
        catch (TechnicalConnectorException e) {
            LOG.error(e.getMessage());
            throw new CredentialException(e);
        }
    }
}

