/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.config.impl;

import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.config.ConfigurationModule;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationModuleSystemProps
implements ConfigurationModule {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationModuleSystemProps.class);
    public static final String SYSTEMPROP_ROOTKEY = "be.ehealth.technicalconnector.config.impl.ConfigurationModuleSystemProps.systemprop";
    private static final String DELIMITER = "=";
    private static final String PATTERN = "(.+?)=(.+)";
    private List<String> oldValues = new ArrayList<String>();
    private static Pattern pattern = Pattern.compile("(.+?)=(.+)");

    @Override
    public void init(Configuration config) throws TechnicalConnectorException {
        LOG.debug("Initializing ConfigurationModule " + this.getClass().getName());
        List<String> systemProps = config.getMatchingProperties(SYSTEMPROP_ROOTKEY);
        for (String systemProp : systemProps) {
            Matcher m = pattern.matcher(systemProp);
            if (m.find()) {
                String key = m.group(1);
                String value = m.group(2);
                LOG.debug("System Property [" + key + "] changed with value [" + value + "].");
                this.oldValues.add(key + DELIMITER + System.getProperty(key));
                System.setProperty(key, value);
                continue;
            }
            throw new IllegalArgumentException("Invalid argument [" + systemProp + "] doesnot match pattern [" + PATTERN + "].");
        }
    }

    @Override
    public void unload() throws TechnicalConnectorException {
        LOG.debug("Unloading ConfigurationModule " + this.getClass().getName());
        for (String systemProp : this.oldValues) {
            String[] splittedProp = systemProp.split(DELIMITER);
            String key = splittedProp[0];
            String value = splittedProp[1];
            if (StringUtils.isEmpty((String)key) || StringUtils.isEmpty((String)value)) continue;
            LOG.debug("System Property [" + key + "] changed with value [" + value + "].");
            System.setProperty(key, value);
        }
        this.oldValues.clear();
    }
}

