/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.test.dicsv4.validator;

import be.ehealth.businessconnector.dicsv4.validator.DicsValidator;
import org.junit.Test;

import be.ehealth.businessconnector.dicsv4.exception.DicsDataNotFoundException;
import be.ehealth.businessconnector.dicsv4.exception.DicsException;
import be.ehealth.businessconnector.dicsv4.validator.impl.DicsValidatorImpl;
import be.fgov.ehealth.commons.core.v2.Status;
import be.fgov.ehealth.commons.core.v2.StatusCode;
import be.fgov.ehealth.commons.protocol.v2.StatusResponseType;

/**
 * @author EHP
 */
public class DicsValidatorImplTest {

    @Test
    public void validatorSuccessTest() throws DicsDataNotFoundException, DicsException {
        StatusResponseType response = new StatusResponseType();

        StatusCode sCodelv1 = new StatusCode();
        sCodelv1.setValue("urn:be:fgov:ehealth:2.0:status:Success");

        Status status = new Status();
        status.setStatusCode(sCodelv1);
        response.setStatus(status);

        DicsValidator validator = new DicsValidatorImpl();
        validator.validateResponse(response);
    }

    @Test(expected = DicsDataNotFoundException.class)
    public void validatorDNFTest() throws DicsDataNotFoundException, DicsException {
        StatusResponseType response = new StatusResponseType();

        StatusCode sCodelv1 = new StatusCode();
        sCodelv1.setValue("urn:be:fgov:ehealth:2.0:status:Success");

        StatusCode sCodelv2 = new StatusCode();
        sCodelv2.setValue("urn:be:fgov:ehealth:2.0:status:DataNotFound");
        sCodelv1.setStatusCode(sCodelv2);

        Status status = new Status();
        status.setStatusCode(sCodelv1);
        response.setStatus(status);

        DicsValidator validator = new DicsValidatorImpl();
        validator.validateResponse(response);
    }

}
