/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import joptsimple.internal.Strings;
import org.mockserver.character.Character;
import org.mockserver.client.serialization.JsonArraySerializer;
import org.mockserver.client.serialization.ObjectMapperFactory;
import org.mockserver.client.serialization.Serializer;
import org.mockserver.client.serialization.model.ExpectationDTO;
import org.mockserver.mock.Expectation;
import org.mockserver.validator.jsonschema.JsonSchemaExpectationValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpectationSerializer
implements Serializer<Expectation> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();
    private JsonArraySerializer jsonArraySerializer = new JsonArraySerializer();
    private JsonSchemaExpectationValidator expectationValidator = new JsonSchemaExpectationValidator();

    @Override
    public String serialize(Expectation expectation) {
        try {
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)new ExpectationDTO(expectation));
        }
        catch (Exception e) {
            this.logger.error(String.format("Exception while serializing expectation to JSON with value %s", expectation), (Throwable)e);
            throw new RuntimeException(String.format("Exception while serializing expectation to JSON with value %s", expectation), e);
        }
    }

    @Override
    public String serialize(List<Expectation> expectations) {
        return this.serialize(expectations.toArray(new Expectation[expectations.size()]));
    }

    @Override
    public String serialize(Expectation ... expectations) {
        try {
            if (expectations != null && expectations.length > 0) {
                ExpectationDTO[] expectationDTOs = new ExpectationDTO[expectations.length];
                for (int i = 0; i < expectations.length; ++i) {
                    expectationDTOs[i] = new ExpectationDTO(expectations[i]);
                }
                return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)expectationDTOs);
            }
            return "";
        }
        catch (Exception e) {
            this.logger.error("Exception while serializing expectation to JSON with value " + Arrays.asList(expectations), (Throwable)e);
            throw new RuntimeException("Exception while serializing expectation to JSON with value " + Arrays.asList(expectations), e);
        }
    }

    @Override
    public Expectation deserialize(String jsonExpectation) {
        if (Strings.isNullOrEmpty((String)jsonExpectation)) {
            throw new IllegalArgumentException("1 error:\n - an expectation is required but value was \"" + String.valueOf(jsonExpectation) + "\"");
        }
        String validationErrors = this.expectationValidator.isValid(jsonExpectation);
        if (validationErrors.isEmpty()) {
            Expectation expectation = null;
            try {
                ExpectationDTO expectationDTO = (ExpectationDTO)this.objectMapper.readValue(jsonExpectation, ExpectationDTO.class);
                if (expectationDTO != null) {
                    expectation = expectationDTO.buildObject();
                }
            }
            catch (Exception e) {
                this.logger.error("Exception while parsing [" + jsonExpectation + "] for Expectation", (Throwable)e);
                throw new RuntimeException("Exception while parsing [" + jsonExpectation + "] for Expectation", e);
            }
            return expectation;
        }
        this.logger.info("Validation failed:" + Character.NEW_LINE + validationErrors + Character.NEW_LINE + "-- Expectation:" + Character.NEW_LINE + jsonExpectation + Character.NEW_LINE + "-- Schema:" + Character.NEW_LINE + this.expectationValidator.getSchema());
        throw new IllegalArgumentException(validationErrors);
    }

    @Override
    public Class<Expectation> supportsType() {
        return Expectation.class;
    }

    public Expectation[] deserializeArray(String jsonExpectations) {
        ArrayList<Expectation> expectations = new ArrayList<Expectation>();
        if (Strings.isNullOrEmpty((String)jsonExpectations)) {
            throw new IllegalArgumentException("1 error:\n - an expectation or expectation array is required but value was \"" + String.valueOf(jsonExpectations) + "\"");
        }
        List<String> jsonExpectationList = this.jsonArraySerializer.returnJSONObjects(jsonExpectations);
        if (jsonExpectationList.isEmpty()) {
            throw new IllegalArgumentException("1 error:\n - an expectation or array of expectations is required");
        }
        ArrayList<String> validationErrorsList = new ArrayList<String>();
        for (String jsonExpecation : jsonExpectationList) {
            try {
                expectations.add(this.deserialize(jsonExpecation));
            }
            catch (IllegalArgumentException iae) {
                validationErrorsList.add(iae.getMessage());
            }
        }
        if (!validationErrorsList.isEmpty()) {
            if (validationErrorsList.size() > 1) {
                throw new IllegalArgumentException(("[\n" + Joiner.on((String)",\n").join(validationErrorsList)).replaceAll("\n", "\n  ") + "\n]");
            }
            throw new IllegalArgumentException((String)validationErrorsList.get(0));
        }
        return expectations.toArray(new Expectation[expectations.size()]);
    }
}

