/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.os;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CloseOnceOutputStream<T extends OutputStream>
extends FilterOutputStream {
    private int closeCount = 0;

    public CloseOnceOutputStream(T source) {
        super((OutputStream)source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        CloseOnceOutputStream closeOnceOutputStream = this;
        synchronized (closeOnceOutputStream) {
            ++this.closeCount;
            if (this.closeCount > 1) {
                return;
            }
        }
        super.close();
    }

    public int getCloseCount() {
        return this.closeCount;
    }

    public T getWrappedOutputStream() {
        OutputStream result = this.out;
        return (T)result;
    }
}

