/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.config.impl;

import be.ehealth.technicalconnector.config.Configuration;
import be.fgov.ehealth.technicalconnector.tests.log4j.TestAppender;
import be.fgov.ehealth.technicalconnector.tests.session.SessionDestroyer;
import be.fgov.ehealth.technicalconnector.tests.utils.AssertTools;
import be.fgov.ehealth.technicalconnector.tests.utils.LoggingUtils;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.After;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameters;

import javax.xml.XMLConstants;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.SchemaFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;


/**
 * TODO: Description of the class.
 *
 * @author EH053
 * @since
 */
@RunWith(Parameterized.class)
public class ConfigurationModuleServiceLoaderTest {

    private String key;
    private ConfigurationModuleServiceLoader serviceLoader = new ConfigurationModuleServiceLoader();

    public ConfigurationModuleServiceLoaderTest(String key) {
        this.key = key;
    }

    @BeforeClass
    public static void init() throws Exception {
        LoggingUtils.bootstrap();
    }

    @Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        Collection<Object[]> data = new ArrayList<Object[]>();
        data.add(new Object[]{DocumentBuilderFactory.class.getName()});
        data.add(new Object[]{SchemaFactory.class.getName() + ":" + XMLConstants.W3C_XML_SCHEMA_NS_URI});
        data.add(new Object[]{SAXParserFactory.class.getName()});
        return data;
    }

    @After
    public void after() throws Exception {
        serviceLoader.unload();
    }

    @Test
    public void test() throws Exception {

        Configuration config = new ConfigurationFake();
        config.setProperty(ConfigurationModuleServiceLoader.SERVICELOADER_ROOTKEY + ".1", key);
        TestAppender appender = LoggingUtils.getTestAppender();
        new ConfigurationModuleServiceLoader().init(config);

        List<LoggingEvent> logEvents = appender.getLogEvents();
        LoggingEvent lastEntry = logEvents.get(logEvents.size() - 1);

        AssertTools.assertLoggingEvent(lastEntry, "debug", ConfigurationModuleServiceLoader.class, ".*implementation:.*loaded from:.*");
    }

}