package be.fgov.ehealth.technicalconnector.services.daas;

import org.junit.Assert;

import java.util.List;
import java.util.Map;

public class DaasAssertionUtils {

    public static void assertAttributeValue(Map<String, List<AttributeValue>> result, String attributeName, int expected, AttributeValue.ValueType type) {
        Assert.assertTrue(result.containsKey(attributeName));
        List<AttributeValue> attributeValues = result.get(attributeName);
        Assert.assertNotNull(attributeValues);
        Assert.assertEquals(expected, attributeValues.size());
        for (AttributeValue attributeValue : attributeValues) {
            Assert.assertEquals(type, attributeValue.getValueType());
        }
    }
}
