/*
 * Copyright (c) eHealth
 */
package be.fgov.ehealth.technicalconnector.bootstrap.tsl.signature;

import static org.junit.Assert.assertTrue;

import org.junit.Test;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.fgov.ehealth.technicalconnector.tests.utils.AssumeTools;


/**
 * @author EH053
 *
 */
public class TrustServcieStatusListSignatureVerifierTest {

    @Test
    public void offline() throws Exception {
        String oldValue = ConfigFactory.getConfigValidator()
                                       .getProperty("KEYSTORE_DIR");
        ConfigFactory.getConfigValidator()
                     .setProperty("KEYSTORE_DIR", "/P12/acc/");
        TrustServiceStatusListSignatureVerifier.reloadCertStore();
        assertTrue(TrustServiceStatusListSignatureVerifier.isValid(ConnectorIOUtils.getResourceAsString("/samples/tsl/acc/tsl-ehpbe-person.xml")));
        ConfigFactory.getConfigValidator()
                     .setProperty("KEYSTORE_DIR", oldValue);
        TrustServiceStatusListSignatureVerifier.reloadCertStore();
    }

    @Test
    public void online() throws Exception {
        AssumeTools.isInternetConnectionEnabled();
        assertTrue(TrustServiceStatusListSignatureVerifier.isValid(ConnectorIOUtils.getResourceAsString("https://tsl-acpt.ehealth.fgov.be/tsl-ehpbe-transport.xml")));
    }

}
