/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.adapter;

import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;


/**
 * Unit test for {@link XmlTimeAdapter}
 *
 * @author Olivier Chapuis (eh077))
 */
public class XmlTimeAdapterTest {

    @Test
    public void testParseTimeWithMilliseconds() throws Exception {
        DateTime parsedTime = new XmlTimeAdapter().unmarshal("15:15:57.270+02:00");
        Assert.assertEquals(15, parsedTime.getHourOfDay());
        Assert.assertEquals(47757270L, parsedTime.getMillis());
        Assert.assertEquals(15, parsedTime.getMinuteOfHour());
        Assert.assertEquals(57, parsedTime.getSecondOfMinute());
        Assert.assertEquals(270, parsedTime.getMillisOfSecond());

    }

    @Test
    public void testParseTimeWithMilliseconds2() throws Exception {
        DateTime parsedTime = new XmlTimeAdapter().unmarshal("15:15:57.2757953248+02:00");
        Assert.assertEquals(15, parsedTime.getHourOfDay());
        Assert.assertEquals(47757275L, parsedTime.getMillis());
        Assert.assertEquals(15, parsedTime.getMinuteOfHour());
        Assert.assertEquals(57, parsedTime.getSecondOfMinute());
        Assert.assertEquals(275, parsedTime.getMillisOfSecond());

    }

    @Test
    public void testPrintTimeNull() throws Exception {
        Assert.assertNull(new XmlTimeAdapter().marshal(null));
    }
}
