/*
 * Decompiled with CFR 0.152.
 */
package sun.net.httpserver;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.Filter;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import sun.net.httpserver.AuthFilter;
import sun.net.httpserver.ServerImpl;

class HttpContextImpl
extends HttpContext {
    private String path;
    private String protocol;
    private HttpHandler handler;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private ServerImpl server;
    private List<Filter> sfilters = new LinkedList<Filter>();
    private List<Filter> ufilters = new LinkedList<Filter>();
    private Authenticator authenticator;
    private AuthFilter authfilter;

    HttpContextImpl(String protocol, String path, HttpHandler cb, ServerImpl server) {
        if (path == null || protocol == null || path.length() < 1 || path.charAt(0) != '/') {
            throw new IllegalArgumentException("Illegal value for path or protocol");
        }
        this.protocol = protocol.toLowerCase();
        this.path = path;
        if (!this.protocol.equals("http") && !this.protocol.equals("https")) {
            throw new IllegalArgumentException("Illegal value for protocol");
        }
        this.handler = cb;
        this.server = server;
        this.authfilter = new AuthFilter(null);
        this.sfilters.add(this.authfilter);
    }

    @Override
    public HttpHandler getHandler() {
        return this.handler;
    }

    @Override
    public void setHandler(HttpHandler h) {
        if (h == null) {
            throw new NullPointerException("Null handler parameter");
        }
        if (this.handler != null) {
            throw new IllegalArgumentException("handler already set");
        }
        this.handler = h;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public HttpServer getServer() {
        return this.server.getWrapper();
    }

    ServerImpl getServerImpl() {
        return this.server;
    }

    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public List<Filter> getFilters() {
        return this.ufilters;
    }

    List<Filter> getSystemFilters() {
        return this.sfilters;
    }

    @Override
    public Authenticator setAuthenticator(Authenticator auth) {
        Authenticator old = this.authenticator;
        this.authenticator = auth;
        this.authfilter.setAuthenticator(auth);
        return old;
    }

    @Override
    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    Logger getLogger() {
        return this.server.getLogger();
    }
}

