package be.fgov.ehealth.standards.kmehr.schema.v1;

import be.fgov.ehealth.standards.kmehr.cd.v1.CDADMINISTRATIONUNIT;
import org.junit.Test;

import javax.xml.bind.JAXB;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;

import static be.fgov.ehealth.standards.kmehr.schema.v1.RegimenFactory.createDayNumber;
import static be.fgov.ehealth.standards.kmehr.schema.v1.RegimenFactory.createQuantity;

public class RegimenTest {

    @Test
    public void test() {

        Regimen regimen = new Regimen();
        regimen.getDaynumbersAndQuantitiesAndDates().add(createDayNumber(BigInteger.valueOf(1)));
        regimen.getDaynumbersAndQuantitiesAndDates().add(createQuantity(BigDecimal.valueOf(1.5), null));
        regimen.getDaynumbersAndQuantitiesAndDates().add(createDayNumber(BigInteger.valueOf(2)));

        AdministrationunitType unitType = new AdministrationunitType();
        CDADMINISTRATIONUNIT cdadministrationunit = new CDADMINISTRATIONUNIT();
        cdadministrationunit.setL("test");
        unitType.setCd(cdadministrationunit);
        cdadministrationunit.setValue("ole");
        regimen.getDaynumbersAndQuantitiesAndDates().add(createQuantity(BigDecimal.valueOf(2.5), unitType));

        StringWriter writer = new StringWriter();
        JAXB.marshal(regimen,writer);

        System.out.println(writer.toString());

    }


}
