/*
 * Copyright (c) eHealth
 */
package be.fgov.ehealth.technicalconnector.tests.soap;

import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.config.ConfigurationModule;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;


/**
 * Configuration Module that replaces the default {@link javax.xml.soap.SOAPConnectionFactory} with the mock implementation.
 * 
 * @author EH053
 * 
 */
public class ConfigurationModuleSOAPConnectionFactory implements ConfigurationModule {

    @Override
    public void init(Configuration config) throws TechnicalConnectorException {
        System.setProperty("javax.xml.soap.SOAPConnectionFactory", SOAPConnectionFactory.class.getName());

    }

    @Override
    public void unload() throws TechnicalConnectorException {
        System.setProperty("javax.xml.soap.SOAPConnectionFactory", "com.sun.xml.internal.messaging.saaj.client.p2p.HttpSOAPConnectionFactory");
    }

}
