/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.jaxb;

import java.io.Serializable;
import java.util.Arrays;

import javax.activation.DataHandler;
import javax.xml.bind.annotation.*;

import be.ehealth.technicalconnector.utils.MarshallerHelperTest;


/**
 * Dummy root class needed for {@link MarshallerHelperTest}
 * 
 * @author EHP
 * 
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "child", propOrder = {"content", "base64"})
public class DummyChild implements Serializable {

    private static final long serialVersionUID = 1L;

    @XmlElement(required = true, type = String.class)
    @XmlAttachmentRef
    protected DataHandler content;

    @XmlElement(name = "base64")
    protected byte[] base64;

    /**
     * Gets the value of the content property.
     * 
     * @author EHP
     * 
     */
    public DataHandler getContent() {
        return content;
    }

    /**
     * Sets the value of the content property.
     * 
     * @param value allowed object is {@link String }
     * 
     */
    public void setContent(DataHandler value) {
        content = value;
    }


    /**
     * @author EHP
     */
    public byte[] getBase64() {
        return base64;
    }

    /**
     * @param base64 the base64 to set
     */
    public void setBase64(byte[] base64) {
        this.base64 = base64;
    }

    /**
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Arrays.hashCode(base64);
        result = prime * result + ((content == null) ? 0 : content.hashCode());
        return result;
    }

    /**
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        DummyChild other = (DummyChild) obj;
        if (!Arrays.equals(base64, other.base64))
            return false;
        if (content == null) {
            if (other.content != null)
                return false;
        } else if (!content.equals(other.content))
            return false;
        return true;
    }


}
