/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.testlisteners;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GlobalNotificationBuildSupport {
    private static final Map<String, Callback> testSuiteCallbacks = new ConcurrentHashMap<String, Callback>();
    private static final Map<Class<?>, Callback> initiatedTestSuiteClasses = new ConcurrentHashMap();
    private static final ThreadLocal<Class<?>> pendingInitiatedTestClass = new ThreadLocal();

    public static void prepareTestSuite(String testClassName, Callback callback) {
        if (testSuiteCallbacks.containsKey(testClassName)) {
            throw new IllegalStateException("Needs to wait for concurrent test-suite execution to start!");
        }
        testSuiteCallbacks.put(testClassName, callback);
        Class<?> initiatedTestClass = pendingInitiatedTestClass.get();
        if (null != initiatedTestClass && initiatedTestClass.getName().equals(testClassName)) {
            System.err.println("Detected late test-suite preparation of already initiated test-" + initiatedTestClass);
            GlobalNotificationBuildSupport.testClassInitiated(initiatedTestClass);
        }
    }

    public static void testClassInitiated(Class<?> testClass) {
        if (!initiatedTestSuiteClasses.containsKey(testClass)) {
            Callback callback = testSuiteCallbacks.get(testClass.getName());
            if (null == callback) {
                pendingInitiatedTestClass.set(testClass);
            } else {
                initiatedTestSuiteClasses.put(testClass, callback);
                callback.suiteClassInitiated(testClass);
                pendingInitiatedTestClass.set(null);
            }
        }
    }

    private static int countInitializersInTrace(String className) {
        int initializerCount = 0;
        for (StackTraceElement ste : new Throwable().getStackTrace()) {
            if (!"<init>".equals(ste.getMethodName()) || !className.equals(ste.getClassName()) || 2 > ++initializerCount) continue;
            return 2;
        }
        return initializerCount;
    }

    public static void testInstanceCreated(Object testInstance) {
        for (Class<?> c = testInstance.getClass(); Object.class != c; c = c.getSuperclass()) {
            Callback callback = initiatedTestSuiteClasses.get(c);
            if (null == callback) continue;
            if (1 == GlobalNotificationBuildSupport.countInitializersInTrace(c.getName())) {
                callback.testInstanceCreated(testInstance);
            }
            return;
        }
    }

    public static void closeTestSuite(Class<?> testClass) {
        Callback callback = initiatedTestSuiteClasses.remove(testClass);
        if (null != callback && !initiatedTestSuiteClasses.values().contains(callback)) {
            testSuiteCallbacks.values().remove(callback);
        }
    }

    public static void closePendingTestSuites(Callback callback) {
        testSuiteCallbacks.values().remove(callback);
        initiatedTestSuiteClasses.values().removeAll(Collections.singleton(callback));
    }

    public static interface Callback {
        public void suiteClassInitiated(Class<?> var1);

        public void testInstanceCreated(Object var1);
    }
}

