﻿/*
 * Copyright (c) eHealth
 */
using System;
using be.ehealth.technicalconnector.session;
using ikvm.extensions;
using NUnit.Framework;
using lang = java.lang;
using java.util;
using joda = org.joda.time;
using be.ehealth.businessconnector.ehbox.api.domain;
using be.ehealth.businessconnector.ehbox.api.domain.exception;
using be.ehealth.businessconnector.ehbox.api.utils;
using be.ehealth.businessconnector.ehbox.v3.builders;
using be.ehealth.businessconnector.ehbox.v3.exception;
using be.ehealth.technicalconnector.exception;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.ehealth.technicalconnector.utils;
using publication = be.fgov.ehealth.ehbox.publication.protocol.v3;
using be.fgov.ehealth.ehbox.core.v3;
using be.fgov.ehealth.ehbox.publication.protocol.v3;
using be.ehealth.businessconnector.ehbox.v3.session;
using be.fgov.ehealth.ehbox.consultation.protocol.v3;
using be.fgov.ehealth.businessconnector.tests.utils;
using be.fgov.ehealth.technicalconnector.tests.utils;

namespace be.ehealth.businessconnector.ehboxv3.session
{
    [TestFixture]
    public class EhboxV3PublicationErrorIntegrationTest
    {    
        [SetUp]
        public void init() {
            java.util.Properties props = new java.util.Properties();
            props.put("session.environment", "acc");
            props.put("session.professionType", "persphysician");
            props.put("session.username", "olivier");
            SessionInitializer.init(props, true, SupportedLanguages.NET.getAbbreviation());
        }

        [TearDown]
        public void tearDown() {
            SessionDestroyer.destroy();
        }

        [Test]
        public void invalidBoxId() {
            DocumentMessage msg = new DocumentMessage();
            Addressee addressee = new Addressee("74123045193", QualityType.DOCTOR_SSIN);
            msg.getDestinations().add(addressee);
            Document doc = new Document();
            doc.setTitle("body");
            doc.setContent("body-eureka".getBytes());
            doc.setMimeType("text/plain");
            doc.setFilename("body.txt");
            msg.setBody(doc);
            msg.setSender(new Addressee("an invalid box id", QualityType.DOCTOR_SSIN));
            SendMessageRequest request = BuilderFactory.getSendMessageBuilder().buildMessage(msg);

            try {
                ServiceFactory.getEhealthBoxServiceV3().sendMessage(request);
                Assert.Fail("Should throw TechnicalConnectorException");
            } catch (TechnicalConnectorException e) {
                Assert.AreEqual("Error while executing web service call: 810: The specified BoxId is invalid; please verify the data and that you can access it.",
                    e.getMessage());
            }
        }
    }
}
