package be.fgov.ehealth.technicalconnector.services.daas;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.fgov.ehealth.technicalconnector.services.ServiceFactory;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import be.fgov.ehealth.technicalconnector.tests.server.HttpServerStub;
import be.fgov.ehealth.technicalconnector.tests.server.asserter.XmlUnitAsserter;
import org.joda.time.DateTime;
import org.junit.*;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static be.fgov.ehealth.technicalconnector.services.daas.AttributeValue.ValueType.ACTOR;
import static be.fgov.ehealth.technicalconnector.services.daas.AttributeValue.ValueType.STRING;
import static be.fgov.ehealth.technicalconnector.services.daas.DaasAssertionUtils.assertAttributeValue;

/**
 * @author EHP
 */
public class DataAttributeServiceTest {

    private static final String CTX_ROOT = "/assert/DAtaAttributeService/v1";

    @ClassRule
    public static SessionRule rule = SessionRule.withInactiveSession()
            .baseOn("/be.ehealth.technicalconnector.daas.test.properties")
            .build();

    private static HttpServerStub server;

    @BeforeClass
    public static void before() throws Exception {
        server = new HttpServerStub(6666);
        ConfigFactory.getConfigValidator().setProperty("endpoint.daas.v1", "http://localhost:6666" + CTX_ROOT);
    }

    @AfterClass
    public static void after(){
        server.shutdown();
    }

    @Test
    public void invokeSuccess() throws Exception {
        server.add(CTX_ROOT, new XmlUnitAsserter("/stub/daas_request.xml", "/stub/daas_response.xml"));

        String ssin = rule.getTestProperty("test.daas.success.ssin");

        Map<String, List<String>> attr = new HashMap<String, List<String>>();
        attr.put("urn:be:fgov:person:ssin", Arrays.asList(ssin));
        attr.put("urn:be:fgov:person:ssin:ehealth:1.0:listofemployers", null);

        DateTime now = new DateTime();

        Map<String, List<AttributeValue>> result = ServiceFactory.getDataAttributeService().invoke(attr, now, now);

        Assert.assertEquals(3, result.size());
        assertAttributeValue(result, "urn:be:fgov:person:ssin", 1, STRING);
        assertAttributeValue(result, "urn:be:fgov:ehealth:1.0:service-name", 1, STRING);
        assertAttributeValue(result, "urn:be:fgov:person:ssin:ehealth:1.0:listofpreventionservices", 3, ACTOR);

    }


}