/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.ra.domain;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class ContactData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Pattern EMAIL_PATTERN = Pattern.compile("[A-Za-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[A-Za-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[A-Za-z0-9](?:[A-Za-z0-9-]*[A-Za-z0-9])?\\.)+[A-Za-z0-9](?:[A-Za-z0-9-]*[A-Za-z0-9])?");
    private static final Pattern PHONE_PATTERN = Pattern.compile("[+0-9][0-9 ]*");
    private String phoneGeneral;
    private String phonePrivate;
    private String emailGeneral;
    private String emailPrivate;

    public ContactData() {
    }

    public ContactData(String phonePrivate, String emailPrivate) {
        this(null, phonePrivate, null, emailPrivate);
    }

    public ContactData(String phoneGeneral, String phonePrivate, String emailGeneral, String emailPrivate) {
        Validate.notEmpty((String)phonePrivate);
        Validate.notEmpty((String)emailPrivate);
        ContactData.isValidPhone(phoneGeneral);
        ContactData.isValidPhone(phonePrivate);
        ContactData.isValidEmail(emailGeneral);
        ContactData.isValidEmail(emailPrivate);
        this.phoneGeneral = phoneGeneral;
        this.phonePrivate = phonePrivate;
        this.emailGeneral = emailGeneral;
        this.emailPrivate = emailPrivate;
    }

    private static void isValidEmail(String emailAddress) {
        if (emailAddress == null) {
            return;
        }
        if (emailAddress.length() > 320) {
            throw new IllegalArgumentException("emailAddress [" + emailAddress + "] to long.");
        }
        Validate.isTrue((boolean)EMAIL_PATTERN.matcher(emailAddress).matches());
    }

    private static void isValidPhone(String phone) {
        if (phone == null) {
            return;
        }
        Validate.isTrue((boolean)PHONE_PATTERN.matcher(phone).matches());
    }

    public void setPhoneGeneral(String phoneGeneral) {
        this.phoneGeneral = phoneGeneral;
    }

    public void setPhonePrivate(String phonePrivate) {
        this.phonePrivate = phonePrivate;
    }

    public void setEmailGeneral(String emailGeneral) {
        this.emailGeneral = emailGeneral;
    }

    public void setEmailPrivate(String emailPrivate) {
        this.emailPrivate = emailPrivate;
    }

    public String getPhoneGeneral() {
        return this.phoneGeneral;
    }

    public String getPhonePrivate() {
        return this.phonePrivate;
    }

    public String getEmailGeneral() {
        return this.emailGeneral;
    }

    public String getEmailPrivate() {
        return this.emailPrivate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContactData that = (ContactData)o;
        return new EqualsBuilder().append((Object)this.getPhoneGeneral(), (Object)that.getPhoneGeneral()).append((Object)this.getPhonePrivate(), (Object)that.getPhonePrivate()).append((Object)this.getEmailGeneral(), (Object)that.getEmailGeneral()).append((Object)this.getEmailPrivate(), (Object)that.getEmailPrivate()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getPhoneGeneral()).append((Object)this.getPhonePrivate()).append((Object)this.getEmailGeneral()).append((Object)this.getEmailPrivate()).toHashCode();
    }
}

