﻿/*
 * Copyright (c) eHealth
 */
using System;
using NUnit.Framework;

using be.ehealth.businessconnector.therlink.builders;
using be.ehealth.businessconnector.therlink.domain;
using be.ehealth.technicalconnector.beid;
using be.ehealth.technicalconnector.config;
using be.ehealth.technicalconnector.service.sts.security;
using be.ehealth.technicalconnector.service.sts.security.impl;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.technicalconnector.signature;
using be.fgov.ehealth.technicalconnector.signature.domain;
using be.fgov.ehealth.technicalconnector.tests.utils;
using be.fgov.ehealth.technicalconnector.tests.session;


namespace be.ehealth.businessconnector.therlink.builders
{
    [TestFixture]
    public class ProofBuilderUserIntegrationTest
    {
        
        private static string SIGNATURE = "Signature";
        
        [SetUp]
        public static void init () {
            AssumeTools.isEIDEnabled();
            be.fgov.ehealth.technicalconnector.tests.session.SessionInitializer.init(".\\be.ehealth.businessconnector.therlink.test.properties", SupportedLanguages.NET.getAbbreviation());
        }
        
        [Test]
        public void testCreateEidSigningProof()
        {
            ConfigFactory.getConfigValidator().getConfig();
            String nissEid = BeIDInfo.getInstance("tests").getIdentity().getNationalNumber();
            Credential cred =  BeIDCredential.getInstance(nissEid, SIGNATURE);
            Proof proof = RequestObjectBuilderFactory.getProofBuilder().createProofForEidSigning(cred);
            
            //3. Validation of the signature
            SignatureVerificationResult result = SignatureBuilderFactory.getSignatureBuilder(AdvancedElectronicSignatureEnumeration.CAdES).verify(null, proof.getBinaryProof().getBinary(), null);
            
            if (!result.isValid()) {
                Assert.Fail("Validation error : " + result);
            }
            
            
            Assert.AreEqual(proof.getType(), ProofTypeValues.EIDSIGNING.getValue());
            Assert.IsNotNull(proof.getBinaryProof());
            Assert.AreEqual(proof.getBinaryProof().getMethod(), "CMS");
        }
    }
}
