/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.validator.impl;

import be.ehealth.technicalconnector.exception.InvalidTimeStampException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConfigurableImplementation;
import be.ehealth.technicalconnector.utils.ConnectorCryptoUtils;
import be.ehealth.technicalconnector.validator.TimeStampValidator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSSignatureAlgorithmNameGenerator;
import org.bouncycastle.cms.DefaultCMSSignatureAlgorithmNameGenerator;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.bc.BcRSASignerInfoVerifierBuilder;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.TimeStampTokenInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeStampValidatorImpl
implements TimeStampValidator,
ConfigurableImplementation {
    private static final Logger LOG = LoggerFactory.getLogger(TimeStampValidatorImpl.class);
    private KeyStore keyStore;
    private List<String> aliases;

    @Override
    public void validateTimeStampToken(byte[] bs, TimeStampToken tsToken) throws InvalidTimeStampException, TechnicalConnectorException {
        byte[] tokenDigestValue;
        byte[] calculatedDigest = ConnectorCryptoUtils.calculateDigest(tsToken.getTimeStampInfo().getMessageImprintAlgOID().getId(), bs);
        if (!MessageDigest.isEqual(calculatedDigest, tokenDigestValue = tsToken.getTimeStampInfo().getMessageImprintDigest())) {
            throw new InvalidTimeStampException("Response for different message imprint digest.");
        }
        Attribute scV1 = tsToken.getSignedAttributes().get(PKCSObjectIdentifiers.id_aa_signingCertificate);
        Attribute scV2 = tsToken.getSignedAttributes().get(PKCSObjectIdentifiers.id_aa_signingCertificateV2);
        if (scV1 == null && scV2 == null) {
            throw new InvalidTimeStampException("no signing certificate attribute present.", null);
        }
        if (scV1 != null && scV2 != null) {
            throw new InvalidTimeStampException("Conflicting signing certificate attributes present.");
        }
        this.validateTimeStampToken(tsToken);
    }

    @Override
    public void validateTimeStampToken(TimeStampToken tsToken) throws InvalidTimeStampException, TechnicalConnectorException {
        Validate.notNull((Object)this.keyStore, (String)"keyStore is not correctly initialised.");
        Validate.notNull(this.aliases, (String)"aliases is not correctly initialised.");
        Validate.notNull((Object)tsToken, (String)"Parameter tsToken value is not nullable.");
        TimeStampTokenInfo timeStampInfo = tsToken.getTimeStampInfo();
        if (timeStampInfo != null) {
            LOG.debug("Validating TimeStampToken with SerialNumber [" + timeStampInfo.getSerialNumber() + "]");
            if (timeStampInfo.getTsa() != null) {
                X500Name name = (X500Name)timeStampInfo.getTsa().getName();
                LOG.debug("Validating Timestamp against TrustStore Looking for [" + name + "].");
            }
        }
        boolean signatureValid = false;
        Exception lastException = null;
        for (String alias : this.aliases) {
            try {
                X509Certificate ttsaCert = (X509Certificate)this.keyStore.getCertificate(alias);
                LOG.debug("Trying to validate timestamp against certificate with alias [" + alias + "] : [" + ttsaCert.getSubjectX500Principal().getName("RFC1779") + "]");
                X509CertificateHolder tokenSigner = new X509CertificateHolder(ttsaCert.getEncoded());
                SignerInformationVerifier verifier = new BcRSASignerInfoVerifierBuilder((CMSSignatureAlgorithmNameGenerator)new DefaultCMSSignatureAlgorithmNameGenerator(), (SignatureAlgorithmIdentifierFinder)new DefaultSignatureAlgorithmIdentifierFinder(), (DigestAlgorithmIdentifierFinder)new DefaultDigestAlgorithmIdentifierFinder(), (DigestCalculatorProvider)new BcDigestCalculatorProvider()).build(tokenSigner);
                tsToken.validate(verifier);
                signatureValid = true;
                break;
            }
            catch (Exception e) {
                lastException = e;
                LOG.debug("TimeStampToken not valid with certificate-alias [" + alias + "]: " + e.getMessage());
            }
        }
        if (!signatureValid) {
            throw new InvalidTimeStampException("timestamp is not valid ", lastException);
        }
        LOG.debug("timestampToken is valid");
    }

    private List<String> getAliases() {
        try {
            return Collections.list(this.keyStore.aliases());
        }
        catch (KeyStoreException e) {
            return new ArrayList<String>();
        }
    }

    @Override
    public void initialize(Map<String, Object> parameterMap) throws TechnicalConnectorException {
        this.setKeyStore((KeyStore)parameterMap.get("timestampvalidatior.keystore"));
        this.aliases = new ArrayList<String>();
        List<String> aliasList = this.getAliases();
        if (aliasList != null) {
            this.aliases.addAll(aliasList);
        }
    }

    @Override
    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    @Override
    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }
}

