/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.handler;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.handler.AbstractSOAPHandler;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.soap.MimeHeaders;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAgentHandler
extends AbstractSOAPHandler {
    private static final String HEADER_NAME = "User-Agent";
    private static final Logger LOG = LoggerFactory.getLogger(UserAgentHandler.class);
    private static Properties applicationProps = new Properties();
    private Configuration config = ConfigFactory.getConfigValidator();
    private static final String KEY_USER_AGENT = "be.ehealth.technicalconnector.handler.user-agent.value";
    private static final String DEFAULT_USER_AGENT = "Ehealth Technical";

    @Override
    public boolean handleOutbound(SOAPMessageContext context) {
        MimeHeaders mimeHeaders;
        if (context.getMessage() != null && (mimeHeaders = context.getMessage().getMimeHeaders()) != null) {
            Object[] agents = mimeHeaders.getHeader(HEADER_NAME);
            if (ArrayUtils.isNotEmpty((Object[])agents)) {
                LOG.info("Removing MIME header [User-Agent] with value [" + StringUtils.join((Object[])agents, (String)",") + "]");
                mimeHeaders.removeHeader(HEADER_NAME);
            }
            String value = this.config.getProperty(KEY_USER_AGENT, DEFAULT_USER_AGENT) + " (" + applicationProps.getProperty("application.version", "unknown") + ")";
            LOG.debug("Adding MIME header [User-Agent] with value [" + value + "]");
            mimeHeaders.addHeader(HEADER_NAME, value);
        }
        return true;
    }

    @Override
    public boolean handleFault(SOAPMessageContext context) {
        return true;
    }

    static {
        InputStream is = null;
        try {
            is = ConnectorIOUtils.getResourceAsStream("/application.properties");
            applicationProps.load(is);
        }
        catch (TechnicalConnectorException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedOperationException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            ConnectorIOUtils.closeQuietly((Object)is);
        }
    }
}

