/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.validator.impl;

import be.ehealth.technicalconnector.exception.SoaErrorException;
import be.ehealth.technicalconnector.validator.EhealthReplyValidator;
import be.fgov.ehealth.commons.core.v1.LocalisedString;
import be.fgov.ehealth.commons.protocol.v1.ResponseType;
import be.fgov.ehealth.commons.protocol.v2.StatusResponseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhealthReplyValidatorImpl
implements EhealthReplyValidator {
    private static final Logger LOG = LoggerFactory.getLogger(EhealthReplyValidatorImpl.class);
    public static final String EHEALTH_SUCCESS_CODE_100 = "100";
    public static final String EHEALTH_SUCCESS_CODE_200 = "200";
    private static final String EHEALTH_SUCCESS_URN = "urn:be:fgov:ehealth:2.0:status:Success";

    @Override
    public boolean validateReplyStatus(ResponseType response) throws SoaErrorException {
        String code = response.getStatus().getCode();
        if (!EHEALTH_SUCCESS_CODE_100.equals(code) && !EHEALTH_SUCCESS_CODE_200.equals(code)) {
            LOG.error("Error Status received : " + code + " " + ((LocalisedString)response.getStatus().getMessages().get(0)).getValue());
            throw new SoaErrorException(code, response);
        }
        return true;
    }

    @Override
    public boolean validateReplyStatus(StatusResponseType response) throws SoaErrorException {
        String code = response.getStatus().getStatusCode().getValue();
        if (!EHEALTH_SUCCESS_URN.equals(code)) {
            LOG.error("Error Status received : " + code + " " + response.getStatus().getStatusMessage());
            throw new SoaErrorException(code, (be.fgov.ehealth.commons.protocol.v2.ResponseType)response);
        }
        return true;
    }
}

