/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.ehbox.v3.service;

import be.ehealth.businessconnector.ehbox.api.domain.exception.EhboxBusinessConnectorException;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.ConfigValidator;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.handler.SchemaValidatorHandler;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.ehealth.technicalconnector.ws.domain.HandlerChain;
import be.ehealth.technicalconnector.ws.domain.HandlerPosition;
import be.ehealth.technicalconnector.ws.domain.TokenType;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.handler.soap.SOAPHandler;

public final class ServiceFactory {
    private static List<String> expectedProps = new ArrayList<String>();
    private static ConfigValidator config;
    public static final String PROP_ENDPOINT_CONSULTATION_V3 = "endpoint.ehbox.consultation.v3";
    public static final String PROP_ENDPOINT_PUBLICATION_V3 = "endpoint.ehbox.publication.v3";
    public static final String PROP_VALIDATION_INCOMING_EHBOX_V3 = "validation.incoming.ehbox.v3.message";
    private static final String EHBOX_CONS_PROT = "/XSD/ehbox_v3/ehealth-ehBox-consultation-schema-protocol-3_0.xsd";
    private static final String EHBOX_PUB_PROT = "/XSD/ehbox_v3/ehealth-ehBox-publication-schema-protocol-3_0.xsd";
    protected static final String[] EHBOXV3_CONS_XSD;
    protected static final String[] EHBOXV3_PUB_XSD;

    private ServiceFactory() {
    }

    public static GenericRequest getConsultationService(SAMLToken token) throws MalformedURLException, TechnicalConnectorException, EhboxBusinessConnectorException {
        GenericRequest genReq = new GenericRequest();
        genReq.setEndpoint(config.getProperty(PROP_ENDPOINT_CONSULTATION_V3));
        genReq.setCredential((Credential)token, TokenType.SAML);
        HandlerChain chain = new HandlerChain();
        if ("true".equalsIgnoreCase(config.getProperty(PROP_VALIDATION_INCOMING_EHBOX_V3))) {
            chain.register(HandlerPosition.BEFORE, (SOAPHandler)new SchemaValidatorHandler(3, EHBOXV3_CONS_XSD));
        } else {
            chain.register(HandlerPosition.BEFORE, (SOAPHandler)new SchemaValidatorHandler(2, EHBOXV3_CONS_XSD));
        }
        genReq.setDefaultHandlerChain();
        genReq.setHandlerChain(chain);
        return genReq;
    }

    public static GenericRequest getPublicationService(SAMLToken token) throws MalformedURLException, TechnicalConnectorException, EhboxBusinessConnectorException {
        GenericRequest genReq = new GenericRequest();
        genReq.setEndpoint(config.getProperty(PROP_ENDPOINT_PUBLICATION_V3));
        genReq.setCredential((Credential)token, TokenType.SAML);
        HandlerChain chain = new HandlerChain();
        if ("true".equalsIgnoreCase(config.getProperty(PROP_VALIDATION_INCOMING_EHBOX_V3))) {
            chain.register(HandlerPosition.BEFORE, (SOAPHandler)new SchemaValidatorHandler(3, EHBOXV3_PUB_XSD));
        } else {
            chain.register(HandlerPosition.BEFORE, (SOAPHandler)new SchemaValidatorHandler(2, EHBOXV3_PUB_XSD));
        }
        genReq.setDefaultHandlerChain();
        genReq.setHandlerChain(chain);
        return genReq;
    }

    static {
        EHBOXV3_CONS_XSD = new String[]{EHBOX_CONS_PROT};
        EHBOXV3_PUB_XSD = new String[]{EHBOX_PUB_PROT};
        expectedProps.add(PROP_ENDPOINT_CONSULTATION_V3);
        expectedProps.add(PROP_ENDPOINT_PUBLICATION_V3);
        expectedProps.add(PROP_VALIDATION_INCOMING_EHBOX_V3);
        config = ConfigFactory.getConfigValidator(expectedProps);
    }
}

