/*
 * Copyright (c) eHealth
 */
package be.fgov.ehealth.technicalconnector.bootstrap.bcp.parser;

import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.fgov.ehealth.technicalconnector.bootstrap.bcp.domain.EndPointInformation;
import be.fgov.ehealth.technicalconnector.tests.utils.LoggingUtils;


/**
 * @author Ehealth
 */
public class StatusPageParserTest {

    private static final Logger LOG = LoggerFactory.getLogger(StatusPageParser.class);

    public static final String SERVICELIST_LOCATION = "/samples/servicelist/local/status.xml";

    @BeforeClass
    public static void before() {
        LoggingUtils.bootstrap();
    }

    @Test
    public void verifyService2AllEndpoints() throws Exception {
        String xml = ConnectorIOUtils.getResourceAsString(SERVICELIST_LOCATION);
        EndPointInformation info = StatusPageParser.parse(xml);
        dump(info.getService2AllEndpoints());
        Assert.assertEquals(3, info.getService2AllEndpoints()
                                   .size());
        Assert.assertEquals(2, info.getService2AllEndpoints()
                                   .get("uddi:ehealth-fgov-be:business:insurability")
                                   .size());
        Assert.assertEquals("https://services-acpt.ehealth.fgov.be/Insurability/v1", info.getService2AllEndpoints()
                                                                                         .get("uddi:ehealth-fgov-be:business:insurability")
                                                                                         .get(0));
        Assert.assertEquals("https://acc.mycarenet.be/Insurability/v1", info.getService2AllEndpoints()
                                                                            .get("uddi:ehealth-fgov-be:business:insurability")
                                                                            .get(1));
        Assert.assertEquals(1, info.getService2AllEndpoints()
                                   .get("uddi:ehealth-fgov-be:business:certra:v1")
                                   .size());
        Assert.assertEquals("https://services-acpt.ehealth.fgov.be/CertRa/v1", info.getService2AllEndpoints()
                                                                                   .get("uddi:ehealth-fgov-be:business:certra:v1")
                                                                                   .get(0));
        Assert.assertEquals(1, info.getService2AllEndpoints()
                                   .get("uddi:ehealth-fgov-be:business:etkra:v1")
                                   .size());
        Assert.assertEquals("https://services-acpt.ehealth.fgov.be/EtkRa/v1", info.getService2AllEndpoints()
                                                                                  .get("uddi:ehealth-fgov-be:business:etkra:v1")
                                                                                  .get(0));
    }

    @Test
    public void verifyService2ActiveEndpoint() throws Exception {
        String xml = ConnectorIOUtils.getResourceAsString(SERVICELIST_LOCATION);
        EndPointInformation info = StatusPageParser.parse(xml);
        dump(info.getService2ActiveEndpoint());
        Assert.assertEquals(2, info.getService2ActiveEndpoint()
                                   .size());
        Assert.assertEquals("https://services-acpt.ehealth.fgov.be/Insurability/v1", info.getService2ActiveEndpoint()
                                                                                         .get("uddi:ehealth-fgov-be:business:insurability"));
        Assert.assertEquals("https://services-acpt.ehealth.fgov.be/CertRa/v1", info.getService2ActiveEndpoint()
                                                                                   .get("uddi:ehealth-fgov-be:business:certra:v1"));

    }

    @Test
    public void verifyUrl2Service() throws Exception {
        String xml = ConnectorIOUtils.getResourceAsString(SERVICELIST_LOCATION);
        EndPointInformation info = StatusPageParser.parse(xml);
        dump(info.getUrl2Service());
        Assert.assertEquals(4, info.getUrl2Service()
                                   .size());
        Assert.assertEquals("uddi:ehealth-fgov-be:business:certra:v1", info.getUrl2Service()
                                                                           .get("https://services-acpt.ehealth.fgov.be/CertRa/v1"));
        Assert.assertEquals("uddi:ehealth-fgov-be:business:etkra:v1", info.getUrl2Service()
                                                                          .get("https://services-acpt.ehealth.fgov.be/EtkRa/v1"));
        Assert.assertEquals("uddi:ehealth-fgov-be:business:insurability", info.getUrl2Service()
                                                                              .get("https://services-acpt.ehealth.fgov.be/Insurability/v1"));
        Assert.assertEquals("uddi:ehealth-fgov-be:business:insurability", info.getUrl2Service()
                                                                              .get("https://acc.mycarenet.be/Insurability/v1"));
    }

    @Test
    public void verifyDefaultUrl() throws Exception {
        String xml = ConnectorIOUtils.getResourceAsString(SERVICELIST_LOCATION);
        EndPointInformation info = StatusPageParser.parse(xml);
        dump(info.getService2DefaultEndpoint());
        Assert.assertEquals(3, info.getService2DefaultEndpoint()
                                   .size());
        Assert.assertEquals("https://services-acpt.ehealth.fgov.be/Insurability/v1", info.getService2DefaultEndpoint()
                                                                                         .get("uddi:ehealth-fgov-be:business:insurability"));
        Assert.assertEquals("https://services-acpt.ehealth.fgov.be/CertRa/v1", info.getService2DefaultEndpoint()
                                                                                   .get("uddi:ehealth-fgov-be:business:certra:v1"));
        Assert.assertEquals("https://services-acpt.ehealth.fgov.be/EtkRa/v1", info.getService2DefaultEndpoint()
                                                                                  .get("uddi:ehealth-fgov-be:business:etkra:v1"));
    }


    private static void dump(final Map<?, ?> m) {
        for (Map.Entry e : m.entrySet()) {
            String retval = "[" + e.getKey() + "] -> ";
            Object value = e.getValue();
            if (value instanceof List) {
                retval += "{" + StringUtils.join(((List) value).toArray(), ", ") + "}";
            } else {
                retval += "[" + value.toString() + "]";
            }
            LOG.debug(retval);
        };
    }

}
